// Code generated by go-swagger; DO NOT EDIT.

package annotations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetAnnotationsReader is a Reader for the GetAnnotations structure.
type GetAnnotationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAnnotationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAnnotationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetAnnotationsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAnnotationsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /annotations] getAnnotations", response, response.Code())
	}
}

// NewGetAnnotationsOK creates a GetAnnotationsOK with default headers values
func NewGetAnnotationsOK() *GetAnnotationsOK {
	return &GetAnnotationsOK{}
}

/*
GetAnnotationsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetAnnotationsOK struct {
	Payload []*models.Annotation
}

// IsSuccess returns true when this get annotations Ok response has a 2xx status code
func (o *GetAnnotationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get annotations Ok response has a 3xx status code
func (o *GetAnnotationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get annotations Ok response has a 4xx status code
func (o *GetAnnotationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get annotations Ok response has a 5xx status code
func (o *GetAnnotationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get annotations Ok response a status code equal to that given
func (o *GetAnnotationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get annotations Ok response
func (o *GetAnnotationsOK) Code() int {
	return 200
}

func (o *GetAnnotationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /annotations][%d] getAnnotationsOk %s", 200, payload)
}

func (o *GetAnnotationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /annotations][%d] getAnnotationsOk %s", 200, payload)
}

func (o *GetAnnotationsOK) GetPayload() []*models.Annotation {
	return o.Payload
}

func (o *GetAnnotationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAnnotationsUnauthorized creates a GetAnnotationsUnauthorized with default headers values
func NewGetAnnotationsUnauthorized() *GetAnnotationsUnauthorized {
	return &GetAnnotationsUnauthorized{}
}

/*
GetAnnotationsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetAnnotationsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get annotations unauthorized response has a 2xx status code
func (o *GetAnnotationsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get annotations unauthorized response has a 3xx status code
func (o *GetAnnotationsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get annotations unauthorized response has a 4xx status code
func (o *GetAnnotationsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get annotations unauthorized response has a 5xx status code
func (o *GetAnnotationsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get annotations unauthorized response a status code equal to that given
func (o *GetAnnotationsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get annotations unauthorized response
func (o *GetAnnotationsUnauthorized) Code() int {
	return 401
}

func (o *GetAnnotationsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /annotations][%d] getAnnotationsUnauthorized %s", 401, payload)
}

func (o *GetAnnotationsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /annotations][%d] getAnnotationsUnauthorized %s", 401, payload)
}

func (o *GetAnnotationsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAnnotationsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAnnotationsInternalServerError creates a GetAnnotationsInternalServerError with default headers values
func NewGetAnnotationsInternalServerError() *GetAnnotationsInternalServerError {
	return &GetAnnotationsInternalServerError{}
}

/*
GetAnnotationsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetAnnotationsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get annotations internal server error response has a 2xx status code
func (o *GetAnnotationsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get annotations internal server error response has a 3xx status code
func (o *GetAnnotationsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get annotations internal server error response has a 4xx status code
func (o *GetAnnotationsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get annotations internal server error response has a 5xx status code
func (o *GetAnnotationsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get annotations internal server error response a status code equal to that given
func (o *GetAnnotationsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get annotations internal server error response
func (o *GetAnnotationsInternalServerError) Code() int {
	return 500
}

func (o *GetAnnotationsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /annotations][%d] getAnnotationsInternalServerError %s", 500, payload)
}

func (o *GetAnnotationsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /annotations][%d] getAnnotationsInternalServerError %s", 500, payload)
}

func (o *GetAnnotationsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAnnotationsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
