// Code generated by go-swagger; DO NOT EDIT.

package dashboard_public

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetPublicDashboardReader is a Reader for the GetPublicDashboard structure.
type GetPublicDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetPublicDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetPublicDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetPublicDashboardBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetPublicDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetPublicDashboardForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetPublicDashboardNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetPublicDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /dashboards/uid/{dashboardUid}/public-dashboards] getPublicDashboard", response, response.Code())
	}
}

// NewGetPublicDashboardOK creates a GetPublicDashboardOK with default headers values
func NewGetPublicDashboardOK() *GetPublicDashboardOK {
	return &GetPublicDashboardOK{}
}

/*
GetPublicDashboardOK describes a response with status code 200, with default header values.

(empty)
*/
type GetPublicDashboardOK struct {
	Payload *models.PublicDashboard
}

// IsSuccess returns true when this get public dashboard Ok response has a 2xx status code
func (o *GetPublicDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get public dashboard Ok response has a 3xx status code
func (o *GetPublicDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public dashboard Ok response has a 4xx status code
func (o *GetPublicDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get public dashboard Ok response has a 5xx status code
func (o *GetPublicDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get public dashboard Ok response a status code equal to that given
func (o *GetPublicDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get public dashboard Ok response
func (o *GetPublicDashboardOK) Code() int {
	return 200
}

func (o *GetPublicDashboardOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardOk %s", 200, payload)
}

func (o *GetPublicDashboardOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardOk %s", 200, payload)
}

func (o *GetPublicDashboardOK) GetPayload() *models.PublicDashboard {
	return o.Payload
}

func (o *GetPublicDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicDashboard)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicDashboardBadRequest creates a GetPublicDashboardBadRequest with default headers values
func NewGetPublicDashboardBadRequest() *GetPublicDashboardBadRequest {
	return &GetPublicDashboardBadRequest{}
}

/*
GetPublicDashboardBadRequest describes a response with status code 400, with default header values.

BadRequestPublicError is returned when the request is invalid and it cannot be processed.
*/
type GetPublicDashboardBadRequest struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public dashboard bad request response has a 2xx status code
func (o *GetPublicDashboardBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public dashboard bad request response has a 3xx status code
func (o *GetPublicDashboardBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public dashboard bad request response has a 4xx status code
func (o *GetPublicDashboardBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public dashboard bad request response has a 5xx status code
func (o *GetPublicDashboardBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get public dashboard bad request response a status code equal to that given
func (o *GetPublicDashboardBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get public dashboard bad request response
func (o *GetPublicDashboardBadRequest) Code() int {
	return 400
}

func (o *GetPublicDashboardBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardBadRequest %s", 400, payload)
}

func (o *GetPublicDashboardBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardBadRequest %s", 400, payload)
}

func (o *GetPublicDashboardBadRequest) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicDashboardBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicDashboardUnauthorized creates a GetPublicDashboardUnauthorized with default headers values
func NewGetPublicDashboardUnauthorized() *GetPublicDashboardUnauthorized {
	return &GetPublicDashboardUnauthorized{}
}

/*
GetPublicDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorisedPublicError is returned when the request is not authenticated.
*/
type GetPublicDashboardUnauthorized struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public dashboard unauthorized response has a 2xx status code
func (o *GetPublicDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public dashboard unauthorized response has a 3xx status code
func (o *GetPublicDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public dashboard unauthorized response has a 4xx status code
func (o *GetPublicDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public dashboard unauthorized response has a 5xx status code
func (o *GetPublicDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get public dashboard unauthorized response a status code equal to that given
func (o *GetPublicDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get public dashboard unauthorized response
func (o *GetPublicDashboardUnauthorized) Code() int {
	return 401
}

func (o *GetPublicDashboardUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardUnauthorized %s", 401, payload)
}

func (o *GetPublicDashboardUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardUnauthorized %s", 401, payload)
}

func (o *GetPublicDashboardUnauthorized) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicDashboardForbidden creates a GetPublicDashboardForbidden with default headers values
func NewGetPublicDashboardForbidden() *GetPublicDashboardForbidden {
	return &GetPublicDashboardForbidden{}
}

/*
GetPublicDashboardForbidden describes a response with status code 403, with default header values.

ForbiddenPublicError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetPublicDashboardForbidden struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public dashboard forbidden response has a 2xx status code
func (o *GetPublicDashboardForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public dashboard forbidden response has a 3xx status code
func (o *GetPublicDashboardForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public dashboard forbidden response has a 4xx status code
func (o *GetPublicDashboardForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public dashboard forbidden response has a 5xx status code
func (o *GetPublicDashboardForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get public dashboard forbidden response a status code equal to that given
func (o *GetPublicDashboardForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get public dashboard forbidden response
func (o *GetPublicDashboardForbidden) Code() int {
	return 403
}

func (o *GetPublicDashboardForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardForbidden %s", 403, payload)
}

func (o *GetPublicDashboardForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardForbidden %s", 403, payload)
}

func (o *GetPublicDashboardForbidden) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicDashboardForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicDashboardNotFound creates a GetPublicDashboardNotFound with default headers values
func NewGetPublicDashboardNotFound() *GetPublicDashboardNotFound {
	return &GetPublicDashboardNotFound{}
}

/*
GetPublicDashboardNotFound describes a response with status code 404, with default header values.

NotFoundPublicError is returned when the requested resource was not found.
*/
type GetPublicDashboardNotFound struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public dashboard not found response has a 2xx status code
func (o *GetPublicDashboardNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public dashboard not found response has a 3xx status code
func (o *GetPublicDashboardNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public dashboard not found response has a 4xx status code
func (o *GetPublicDashboardNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public dashboard not found response has a 5xx status code
func (o *GetPublicDashboardNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get public dashboard not found response a status code equal to that given
func (o *GetPublicDashboardNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get public dashboard not found response
func (o *GetPublicDashboardNotFound) Code() int {
	return 404
}

func (o *GetPublicDashboardNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardNotFound %s", 404, payload)
}

func (o *GetPublicDashboardNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardNotFound %s", 404, payload)
}

func (o *GetPublicDashboardNotFound) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicDashboardNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicDashboardInternalServerError creates a GetPublicDashboardInternalServerError with default headers values
func NewGetPublicDashboardInternalServerError() *GetPublicDashboardInternalServerError {
	return &GetPublicDashboardInternalServerError{}
}

/*
GetPublicDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerPublicError is a general error indicating something went wrong internally.
*/
type GetPublicDashboardInternalServerError struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public dashboard internal server error response has a 2xx status code
func (o *GetPublicDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public dashboard internal server error response has a 3xx status code
func (o *GetPublicDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public dashboard internal server error response has a 4xx status code
func (o *GetPublicDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get public dashboard internal server error response has a 5xx status code
func (o *GetPublicDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get public dashboard internal server error response a status code equal to that given
func (o *GetPublicDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get public dashboard internal server error response
func (o *GetPublicDashboardInternalServerError) Code() int {
	return 500
}

func (o *GetPublicDashboardInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardInternalServerError %s", 500, payload)
}

func (o *GetPublicDashboardInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dashboards/uid/{dashboardUid}/public-dashboards][%d] getPublicDashboardInternalServerError %s", 500, payload)
}

func (o *GetPublicDashboardInternalServerError) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
