// Code generated by go-swagger; DO NOT EDIT.

package dashboard_versions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewRestoreDashboardVersionByIDParams creates a new RestoreDashboardVersionByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRestoreDashboardVersionByIDParams() *RestoreDashboardVersionByIDParams {
	return &RestoreDashboardVersionByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRestoreDashboardVersionByIDParamsWithTimeout creates a new RestoreDashboardVersionByIDParams object
// with the ability to set a timeout on a request.
func NewRestoreDashboardVersionByIDParamsWithTimeout(timeout time.Duration) *RestoreDashboardVersionByIDParams {
	return &RestoreDashboardVersionByIDParams{
		timeout: timeout,
	}
}

// NewRestoreDashboardVersionByIDParamsWithContext creates a new RestoreDashboardVersionByIDParams object
// with the ability to set a context for a request.
func NewRestoreDashboardVersionByIDParamsWithContext(ctx context.Context) *RestoreDashboardVersionByIDParams {
	return &RestoreDashboardVersionByIDParams{
		Context: ctx,
	}
}

// NewRestoreDashboardVersionByIDParamsWithHTTPClient creates a new RestoreDashboardVersionByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewRestoreDashboardVersionByIDParamsWithHTTPClient(client *http.Client) *RestoreDashboardVersionByIDParams {
	return &RestoreDashboardVersionByIDParams{
		HTTPClient: client,
	}
}

/*
RestoreDashboardVersionByIDParams contains all the parameters to send to the API endpoint

	for the restore dashboard version by ID operation.

	Typically these are written to a http.Request.
*/
type RestoreDashboardVersionByIDParams struct {

	// Body.
	Body *models.RestoreDashboardVersionCommand

	// DashboardID.
	//
	// Format: int64
	DashboardID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the restore dashboard version by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RestoreDashboardVersionByIDParams) WithDefaults() *RestoreDashboardVersionByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the restore dashboard version by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RestoreDashboardVersionByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) WithTimeout(timeout time.Duration) *RestoreDashboardVersionByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) WithContext(ctx context.Context) *RestoreDashboardVersionByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) WithHTTPClient(client *http.Client) *RestoreDashboardVersionByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) WithBody(body *models.RestoreDashboardVersionCommand) *RestoreDashboardVersionByIDParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) SetBody(body *models.RestoreDashboardVersionCommand) {
	o.Body = body
}

// WithDashboardID adds the dashboardID to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) WithDashboardID(dashboardID int64) *RestoreDashboardVersionByIDParams {
	o.SetDashboardID(dashboardID)
	return o
}

// SetDashboardID adds the dashboardId to the restore dashboard version by ID params
func (o *RestoreDashboardVersionByIDParams) SetDashboardID(dashboardID int64) {
	o.DashboardID = dashboardID
}

// WriteToRequest writes these params to a swagger request
func (o *RestoreDashboardVersionByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param DashboardID
	if err := r.SetPathParam("DashboardID", swag.FormatInt64(o.DashboardID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
