// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteDataSourceByUIDReader is a Reader for the DeleteDataSourceByUID structure.
type DeleteDataSourceByUIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteDataSourceByUIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteDataSourceByUIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeleteDataSourceByUIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteDataSourceByUIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteDataSourceByUIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteDataSourceByUIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /datasources/uid/{uid}] deleteDataSourceByUID", response, response.Code())
	}
}

// NewDeleteDataSourceByUIDOK creates a DeleteDataSourceByUIDOK with default headers values
func NewDeleteDataSourceByUIDOK() *DeleteDataSourceByUIDOK {
	return &DeleteDataSourceByUIDOK{}
}

/*
DeleteDataSourceByUIDOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeleteDataSourceByUIDOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete data source by Uid Ok response has a 2xx status code
func (o *DeleteDataSourceByUIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete data source by Uid Ok response has a 3xx status code
func (o *DeleteDataSourceByUIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Uid Ok response has a 4xx status code
func (o *DeleteDataSourceByUIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete data source by Uid Ok response has a 5xx status code
func (o *DeleteDataSourceByUIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Uid Ok response a status code equal to that given
func (o *DeleteDataSourceByUIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete data source by Uid Ok response
func (o *DeleteDataSourceByUIDOK) Code() int {
	return 200
}

func (o *DeleteDataSourceByUIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidOk %s", 200, payload)
}

func (o *DeleteDataSourceByUIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidOk %s", 200, payload)
}

func (o *DeleteDataSourceByUIDOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByUIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByUIDUnauthorized creates a DeleteDataSourceByUIDUnauthorized with default headers values
func NewDeleteDataSourceByUIDUnauthorized() *DeleteDataSourceByUIDUnauthorized {
	return &DeleteDataSourceByUIDUnauthorized{}
}

/*
DeleteDataSourceByUIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteDataSourceByUIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Uid unauthorized response has a 2xx status code
func (o *DeleteDataSourceByUIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Uid unauthorized response has a 3xx status code
func (o *DeleteDataSourceByUIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Uid unauthorized response has a 4xx status code
func (o *DeleteDataSourceByUIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by Uid unauthorized response has a 5xx status code
func (o *DeleteDataSourceByUIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Uid unauthorized response a status code equal to that given
func (o *DeleteDataSourceByUIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete data source by Uid unauthorized response
func (o *DeleteDataSourceByUIDUnauthorized) Code() int {
	return 401
}

func (o *DeleteDataSourceByUIDUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidUnauthorized %s", 401, payload)
}

func (o *DeleteDataSourceByUIDUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidUnauthorized %s", 401, payload)
}

func (o *DeleteDataSourceByUIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByUIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByUIDForbidden creates a DeleteDataSourceByUIDForbidden with default headers values
func NewDeleteDataSourceByUIDForbidden() *DeleteDataSourceByUIDForbidden {
	return &DeleteDataSourceByUIDForbidden{}
}

/*
DeleteDataSourceByUIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteDataSourceByUIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Uid forbidden response has a 2xx status code
func (o *DeleteDataSourceByUIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Uid forbidden response has a 3xx status code
func (o *DeleteDataSourceByUIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Uid forbidden response has a 4xx status code
func (o *DeleteDataSourceByUIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by Uid forbidden response has a 5xx status code
func (o *DeleteDataSourceByUIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Uid forbidden response a status code equal to that given
func (o *DeleteDataSourceByUIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete data source by Uid forbidden response
func (o *DeleteDataSourceByUIDForbidden) Code() int {
	return 403
}

func (o *DeleteDataSourceByUIDForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidForbidden %s", 403, payload)
}

func (o *DeleteDataSourceByUIDForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidForbidden %s", 403, payload)
}

func (o *DeleteDataSourceByUIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByUIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByUIDNotFound creates a DeleteDataSourceByUIDNotFound with default headers values
func NewDeleteDataSourceByUIDNotFound() *DeleteDataSourceByUIDNotFound {
	return &DeleteDataSourceByUIDNotFound{}
}

/*
DeleteDataSourceByUIDNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteDataSourceByUIDNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Uid not found response has a 2xx status code
func (o *DeleteDataSourceByUIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Uid not found response has a 3xx status code
func (o *DeleteDataSourceByUIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Uid not found response has a 4xx status code
func (o *DeleteDataSourceByUIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by Uid not found response has a 5xx status code
func (o *DeleteDataSourceByUIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by Uid not found response a status code equal to that given
func (o *DeleteDataSourceByUIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete data source by Uid not found response
func (o *DeleteDataSourceByUIDNotFound) Code() int {
	return 404
}

func (o *DeleteDataSourceByUIDNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidNotFound %s", 404, payload)
}

func (o *DeleteDataSourceByUIDNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidNotFound %s", 404, payload)
}

func (o *DeleteDataSourceByUIDNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByUIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByUIDInternalServerError creates a DeleteDataSourceByUIDInternalServerError with default headers values
func NewDeleteDataSourceByUIDInternalServerError() *DeleteDataSourceByUIDInternalServerError {
	return &DeleteDataSourceByUIDInternalServerError{}
}

/*
DeleteDataSourceByUIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteDataSourceByUIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by Uid internal server error response has a 2xx status code
func (o *DeleteDataSourceByUIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by Uid internal server error response has a 3xx status code
func (o *DeleteDataSourceByUIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by Uid internal server error response has a 4xx status code
func (o *DeleteDataSourceByUIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete data source by Uid internal server error response has a 5xx status code
func (o *DeleteDataSourceByUIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete data source by Uid internal server error response a status code equal to that given
func (o *DeleteDataSourceByUIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete data source by Uid internal server error response
func (o *DeleteDataSourceByUIDInternalServerError) Code() int {
	return 500
}

func (o *DeleteDataSourceByUIDInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidInternalServerError %s", 500, payload)
}

func (o *DeleteDataSourceByUIDInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}][%d] deleteDataSourceByUidInternalServerError %s", 500, payload)
}

func (o *DeleteDataSourceByUIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByUIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
