// Code generated by go-swagger; DO NOT EDIT.

package devices

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SearchDevicesReader is a Reader for the SearchDevices structure.
type SearchDevicesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchDevicesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchDevicesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSearchDevicesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSearchDevicesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewSearchDevicesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSearchDevicesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /search] SearchDevices", response, response.Code())
	}
}

// NewSearchDevicesOK creates a SearchDevicesOK with default headers values
func NewSearchDevicesOK() *SearchDevicesOK {
	return &SearchDevicesOK{}
}

/*
SearchDevicesOK describes a response with status code 200, with default header values.

(empty)
*/
type SearchDevicesOK struct {
	Payload *models.SearchDeviceQueryResult
}

// IsSuccess returns true when this search devices Ok response has a 2xx status code
func (o *SearchDevicesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search devices Ok response has a 3xx status code
func (o *SearchDevicesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search devices Ok response has a 4xx status code
func (o *SearchDevicesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search devices Ok response has a 5xx status code
func (o *SearchDevicesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search devices Ok response a status code equal to that given
func (o *SearchDevicesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search devices Ok response
func (o *SearchDevicesOK) Code() int {
	return 200
}

func (o *SearchDevicesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesOk %s", 200, payload)
}

func (o *SearchDevicesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesOk %s", 200, payload)
}

func (o *SearchDevicesOK) GetPayload() *models.SearchDeviceQueryResult {
	return o.Payload
}

func (o *SearchDevicesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SearchDeviceQueryResult)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchDevicesUnauthorized creates a SearchDevicesUnauthorized with default headers values
func NewSearchDevicesUnauthorized() *SearchDevicesUnauthorized {
	return &SearchDevicesUnauthorized{}
}

/*
SearchDevicesUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SearchDevicesUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search devices unauthorized response has a 2xx status code
func (o *SearchDevicesUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search devices unauthorized response has a 3xx status code
func (o *SearchDevicesUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search devices unauthorized response has a 4xx status code
func (o *SearchDevicesUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this search devices unauthorized response has a 5xx status code
func (o *SearchDevicesUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this search devices unauthorized response a status code equal to that given
func (o *SearchDevicesUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the search devices unauthorized response
func (o *SearchDevicesUnauthorized) Code() int {
	return 401
}

func (o *SearchDevicesUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesUnauthorized %s", 401, payload)
}

func (o *SearchDevicesUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesUnauthorized %s", 401, payload)
}

func (o *SearchDevicesUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchDevicesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchDevicesForbidden creates a SearchDevicesForbidden with default headers values
func NewSearchDevicesForbidden() *SearchDevicesForbidden {
	return &SearchDevicesForbidden{}
}

/*
SearchDevicesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SearchDevicesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search devices forbidden response has a 2xx status code
func (o *SearchDevicesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search devices forbidden response has a 3xx status code
func (o *SearchDevicesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search devices forbidden response has a 4xx status code
func (o *SearchDevicesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this search devices forbidden response has a 5xx status code
func (o *SearchDevicesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this search devices forbidden response a status code equal to that given
func (o *SearchDevicesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the search devices forbidden response
func (o *SearchDevicesForbidden) Code() int {
	return 403
}

func (o *SearchDevicesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesForbidden %s", 403, payload)
}

func (o *SearchDevicesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesForbidden %s", 403, payload)
}

func (o *SearchDevicesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchDevicesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchDevicesNotFound creates a SearchDevicesNotFound with default headers values
func NewSearchDevicesNotFound() *SearchDevicesNotFound {
	return &SearchDevicesNotFound{}
}

/*
SearchDevicesNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type SearchDevicesNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search devices not found response has a 2xx status code
func (o *SearchDevicesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search devices not found response has a 3xx status code
func (o *SearchDevicesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search devices not found response has a 4xx status code
func (o *SearchDevicesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this search devices not found response has a 5xx status code
func (o *SearchDevicesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this search devices not found response a status code equal to that given
func (o *SearchDevicesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the search devices not found response
func (o *SearchDevicesNotFound) Code() int {
	return 404
}

func (o *SearchDevicesNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesNotFound %s", 404, payload)
}

func (o *SearchDevicesNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesNotFound %s", 404, payload)
}

func (o *SearchDevicesNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchDevicesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchDevicesInternalServerError creates a SearchDevicesInternalServerError with default headers values
func NewSearchDevicesInternalServerError() *SearchDevicesInternalServerError {
	return &SearchDevicesInternalServerError{}
}

/*
SearchDevicesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SearchDevicesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search devices internal server error response has a 2xx status code
func (o *SearchDevicesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search devices internal server error response has a 3xx status code
func (o *SearchDevicesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search devices internal server error response has a 4xx status code
func (o *SearchDevicesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this search devices internal server error response has a 5xx status code
func (o *SearchDevicesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this search devices internal server error response a status code equal to that given
func (o *SearchDevicesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the search devices internal server error response
func (o *SearchDevicesInternalServerError) Code() int {
	return 500
}

func (o *SearchDevicesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesInternalServerError %s", 500, payload)
}

func (o *SearchDevicesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /search][%d] searchDevicesInternalServerError %s", 500, payload)
}

func (o *SearchDevicesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchDevicesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
