// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new migrations API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for migrations API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CancelSnapshot(uid string, snapshotUID string, opts ...ClientOption) (*CancelSnapshotOK, error)
	CancelSnapshotWithParams(params *CancelSnapshotParams, opts ...ClientOption) (*CancelSnapshotOK, error)

	CreateCloudMigrationToken(opts ...ClientOption) (*CreateCloudMigrationTokenOK, error)
	CreateCloudMigrationTokenWithParams(params *CreateCloudMigrationTokenParams, opts ...ClientOption) (*CreateCloudMigrationTokenOK, error)

	CreateSession(body *models.CloudMigrationSessionRequestDTO, opts ...ClientOption) (*CreateSessionOK, error)
	CreateSessionWithParams(params *CreateSessionParams, opts ...ClientOption) (*CreateSessionOK, error)

	CreateSnapshot(uid string, opts ...ClientOption) (*CreateSnapshotOK, error)
	CreateSnapshotWithParams(params *CreateSnapshotParams, opts ...ClientOption) (*CreateSnapshotOK, error)

	DeleteCloudMigrationToken(uid string, opts ...ClientOption) (*DeleteCloudMigrationTokenNoContent, error)
	DeleteCloudMigrationTokenWithParams(params *DeleteCloudMigrationTokenParams, opts ...ClientOption) (*DeleteCloudMigrationTokenNoContent, error)

	DeleteSession(uid string, opts ...ClientOption) error
	DeleteSessionWithParams(params *DeleteSessionParams, opts ...ClientOption) error

	GetCloudMigrationToken(opts ...ClientOption) (*GetCloudMigrationTokenOK, error)
	GetCloudMigrationTokenWithParams(params *GetCloudMigrationTokenParams, opts ...ClientOption) (*GetCloudMigrationTokenOK, error)

	GetSession(uid string, opts ...ClientOption) (*GetSessionOK, error)
	GetSessionWithParams(params *GetSessionParams, opts ...ClientOption) (*GetSessionOK, error)

	GetSessionList(opts ...ClientOption) (*GetSessionListOK, error)
	GetSessionListWithParams(params *GetSessionListParams, opts ...ClientOption) (*GetSessionListOK, error)

	GetShapshotList(params *GetShapshotListParams, opts ...ClientOption) (*GetShapshotListOK, error)

	GetSnapshot(params *GetSnapshotParams, opts ...ClientOption) (*GetSnapshotOK, error)

	UploadSnapshot(uid string, snapshotUID string, opts ...ClientOption) (*UploadSnapshotOK, error)
	UploadSnapshotWithParams(params *UploadSnapshotParams, opts ...ClientOption) (*UploadSnapshotOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CancelSnapshot cancels a snapshot wherever it is in its processing chain

TODO: Implement
*/
func (a *Client) CancelSnapshot(uid string, snapshotUID string, opts ...ClientOption) (*CancelSnapshotOK, error) {
	params := NewCancelSnapshotParams().WithSnapshotUID(snapshotUID).WithUID(uid)
	return a.CancelSnapshotWithParams(params, opts...)
}

func (a *Client) CancelSnapshotWithParams(params *CancelSnapshotParams, opts ...ClientOption) (*CancelSnapshotOK, error) {
	if params == nil {
		params = NewCancelSnapshotParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cancelSnapshot",
		Method:             "POST",
		PathPattern:        "/cloudmigration/migration/{uid}/snapshot/{snapshotUid}/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CancelSnapshotReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CancelSnapshotOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for cancelSnapshot: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateCloudMigrationToken creates gcom access token
*/
func (a *Client) CreateCloudMigrationToken(opts ...ClientOption) (*CreateCloudMigrationTokenOK, error) {
	params := NewCreateCloudMigrationTokenParams()
	return a.CreateCloudMigrationTokenWithParams(params, opts...)
}

func (a *Client) CreateCloudMigrationTokenWithParams(params *CreateCloudMigrationTokenParams, opts ...ClientOption) (*CreateCloudMigrationTokenOK, error) {
	if params == nil {
		params = NewCreateCloudMigrationTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createCloudMigrationToken",
		Method:             "POST",
		PathPattern:        "/cloudmigration/token",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateCloudMigrationTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateCloudMigrationTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createCloudMigrationToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateSession creates a migration session
*/
func (a *Client) CreateSession(body *models.CloudMigrationSessionRequestDTO, opts ...ClientOption) (*CreateSessionOK, error) {
	params := NewCreateSessionParams().WithBody(body)
	return a.CreateSessionWithParams(params, opts...)
}

func (a *Client) CreateSessionWithParams(params *CreateSessionParams, opts ...ClientOption) (*CreateSessionOK, error) {
	if params == nil {
		params = NewCreateSessionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createSession",
		Method:             "POST",
		PathPattern:        "/cloudmigration/migration",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateSessionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateSessionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createSession: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateSnapshot triggers the creation of an instance snapshot associated with the provided session

If the snapshot initialization is successful, the snapshot uid is returned.
*/
func (a *Client) CreateSnapshot(uid string, opts ...ClientOption) (*CreateSnapshotOK, error) {
	params := NewCreateSnapshotParams().WithUID(uid)
	return a.CreateSnapshotWithParams(params, opts...)
}

func (a *Client) CreateSnapshotWithParams(params *CreateSnapshotParams, opts ...ClientOption) (*CreateSnapshotOK, error) {
	if params == nil {
		params = NewCreateSnapshotParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createSnapshot",
		Method:             "POST",
		PathPattern:        "/cloudmigration/migration/{uid}/snapshot",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateSnapshotReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateSnapshotOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createSnapshot: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteCloudMigrationToken deletes a cloud migration token
*/
func (a *Client) DeleteCloudMigrationToken(uid string, opts ...ClientOption) (*DeleteCloudMigrationTokenNoContent, error) {
	params := NewDeleteCloudMigrationTokenParams().WithUID(uid)
	return a.DeleteCloudMigrationTokenWithParams(params, opts...)
}

func (a *Client) DeleteCloudMigrationTokenWithParams(params *DeleteCloudMigrationTokenParams, opts ...ClientOption) (*DeleteCloudMigrationTokenNoContent, error) {
	if params == nil {
		params = NewDeleteCloudMigrationTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteCloudMigrationToken",
		Method:             "DELETE",
		PathPattern:        "/cloudmigration/token/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteCloudMigrationTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteCloudMigrationTokenNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteCloudMigrationToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteSession deletes a migration session by its uid
*/
func (a *Client) DeleteSession(uid string, opts ...ClientOption) error {
	params := NewDeleteSessionParams().WithUID(uid)
	return a.DeleteSessionWithParams(params, opts...)
}

func (a *Client) DeleteSessionWithParams(params *DeleteSessionParams, opts ...ClientOption) error {
	if params == nil {
		params = NewDeleteSessionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteSession",
		Method:             "DELETE",
		PathPattern:        "/cloudmigration/migration/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteSessionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	_, err := a.transport.Submit(op)
	if err != nil {
		return err
	}
	return nil
}

/*
GetCloudMigrationToken fetches the cloud migration token if it exists
*/
func (a *Client) GetCloudMigrationToken(opts ...ClientOption) (*GetCloudMigrationTokenOK, error) {
	params := NewGetCloudMigrationTokenParams()
	return a.GetCloudMigrationTokenWithParams(params, opts...)
}

func (a *Client) GetCloudMigrationTokenWithParams(params *GetCloudMigrationTokenParams, opts ...ClientOption) (*GetCloudMigrationTokenOK, error) {
	if params == nil {
		params = NewGetCloudMigrationTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getCloudMigrationToken",
		Method:             "GET",
		PathPattern:        "/cloudmigration/token",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetCloudMigrationTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetCloudMigrationTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getCloudMigrationToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSession gets a cloud migration session by its uid
*/
func (a *Client) GetSession(uid string, opts ...ClientOption) (*GetSessionOK, error) {
	params := NewGetSessionParams().WithUID(uid)
	return a.GetSessionWithParams(params, opts...)
}

func (a *Client) GetSessionWithParams(params *GetSessionParams, opts ...ClientOption) (*GetSessionOK, error) {
	if params == nil {
		params = NewGetSessionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSession",
		Method:             "GET",
		PathPattern:        "/cloudmigration/migration/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSessionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSessionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSession: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSessionList gets a list of all cloud migration sessions that have been created
*/
func (a *Client) GetSessionList(opts ...ClientOption) (*GetSessionListOK, error) {
	params := NewGetSessionListParams()
	return a.GetSessionListWithParams(params, opts...)
}

func (a *Client) GetSessionListWithParams(params *GetSessionListParams, opts ...ClientOption) (*GetSessionListOK, error) {
	if params == nil {
		params = NewGetSessionListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSessionList",
		Method:             "GET",
		PathPattern:        "/cloudmigration/migration",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSessionListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSessionListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSessionList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetShapshotList gets a list of snapshots for a session
*/

func (a *Client) GetShapshotList(params *GetShapshotListParams, opts ...ClientOption) (*GetShapshotListOK, error) {
	if params == nil {
		params = NewGetShapshotListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getShapshotList",
		Method:             "GET",
		PathPattern:        "/cloudmigration/migration/{uid}/snapshots",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetShapshotListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetShapshotListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getShapshotList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSnapshot gets metadata about a snapshot including where it is in its processing and final results
*/

func (a *Client) GetSnapshot(params *GetSnapshotParams, opts ...ClientOption) (*GetSnapshotOK, error) {
	if params == nil {
		params = NewGetSnapshotParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSnapshot",
		Method:             "GET",
		PathPattern:        "/cloudmigration/migration/{uid}/snapshot/{snapshotUid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSnapshotReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSnapshotOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSnapshot: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UploadSnapshot uploads a snapshot to the grafana migration service for processing
*/
func (a *Client) UploadSnapshot(uid string, snapshotUID string, opts ...ClientOption) (*UploadSnapshotOK, error) {
	params := NewUploadSnapshotParams().WithSnapshotUID(snapshotUID).WithUID(uid)
	return a.UploadSnapshotWithParams(params, opts...)
}

func (a *Client) UploadSnapshotWithParams(params *UploadSnapshotParams, opts ...ClientOption) (*UploadSnapshotOK, error) {
	if params == nil {
		params = NewUploadSnapshotParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "uploadSnapshot",
		Method:             "POST",
		PathPattern:        "/cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadSnapshotReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UploadSnapshotOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for uploadSnapshot: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
