// Code generated by go-swagger; DO NOT EDIT.

package org_preferences

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateOrgPreferencesReader is a Reader for the UpdateOrgPreferences structure.
type UpdateOrgPreferencesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateOrgPreferencesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateOrgPreferencesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateOrgPreferencesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateOrgPreferencesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateOrgPreferencesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateOrgPreferencesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /org/preferences] updateOrgPreferences", response, response.Code())
	}
}

// NewUpdateOrgPreferencesOK creates a UpdateOrgPreferencesOK with default headers values
func NewUpdateOrgPreferencesOK() *UpdateOrgPreferencesOK {
	return &UpdateOrgPreferencesOK{}
}

/*
UpdateOrgPreferencesOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateOrgPreferencesOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update org preferences Ok response has a 2xx status code
func (o *UpdateOrgPreferencesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update org preferences Ok response has a 3xx status code
func (o *UpdateOrgPreferencesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org preferences Ok response has a 4xx status code
func (o *UpdateOrgPreferencesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update org preferences Ok response has a 5xx status code
func (o *UpdateOrgPreferencesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update org preferences Ok response a status code equal to that given
func (o *UpdateOrgPreferencesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update org preferences Ok response
func (o *UpdateOrgPreferencesOK) Code() int {
	return 200
}

func (o *UpdateOrgPreferencesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesOk %s", 200, payload)
}

func (o *UpdateOrgPreferencesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesOk %s", 200, payload)
}

func (o *UpdateOrgPreferencesOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateOrgPreferencesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgPreferencesBadRequest creates a UpdateOrgPreferencesBadRequest with default headers values
func NewUpdateOrgPreferencesBadRequest() *UpdateOrgPreferencesBadRequest {
	return &UpdateOrgPreferencesBadRequest{}
}

/*
UpdateOrgPreferencesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateOrgPreferencesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org preferences bad request response has a 2xx status code
func (o *UpdateOrgPreferencesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org preferences bad request response has a 3xx status code
func (o *UpdateOrgPreferencesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org preferences bad request response has a 4xx status code
func (o *UpdateOrgPreferencesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org preferences bad request response has a 5xx status code
func (o *UpdateOrgPreferencesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update org preferences bad request response a status code equal to that given
func (o *UpdateOrgPreferencesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update org preferences bad request response
func (o *UpdateOrgPreferencesBadRequest) Code() int {
	return 400
}

func (o *UpdateOrgPreferencesBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesBadRequest %s", 400, payload)
}

func (o *UpdateOrgPreferencesBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesBadRequest %s", 400, payload)
}

func (o *UpdateOrgPreferencesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgPreferencesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgPreferencesUnauthorized creates a UpdateOrgPreferencesUnauthorized with default headers values
func NewUpdateOrgPreferencesUnauthorized() *UpdateOrgPreferencesUnauthorized {
	return &UpdateOrgPreferencesUnauthorized{}
}

/*
UpdateOrgPreferencesUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateOrgPreferencesUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org preferences unauthorized response has a 2xx status code
func (o *UpdateOrgPreferencesUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org preferences unauthorized response has a 3xx status code
func (o *UpdateOrgPreferencesUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org preferences unauthorized response has a 4xx status code
func (o *UpdateOrgPreferencesUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org preferences unauthorized response has a 5xx status code
func (o *UpdateOrgPreferencesUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update org preferences unauthorized response a status code equal to that given
func (o *UpdateOrgPreferencesUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update org preferences unauthorized response
func (o *UpdateOrgPreferencesUnauthorized) Code() int {
	return 401
}

func (o *UpdateOrgPreferencesUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesUnauthorized %s", 401, payload)
}

func (o *UpdateOrgPreferencesUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesUnauthorized %s", 401, payload)
}

func (o *UpdateOrgPreferencesUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgPreferencesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgPreferencesForbidden creates a UpdateOrgPreferencesForbidden with default headers values
func NewUpdateOrgPreferencesForbidden() *UpdateOrgPreferencesForbidden {
	return &UpdateOrgPreferencesForbidden{}
}

/*
UpdateOrgPreferencesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateOrgPreferencesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org preferences forbidden response has a 2xx status code
func (o *UpdateOrgPreferencesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org preferences forbidden response has a 3xx status code
func (o *UpdateOrgPreferencesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org preferences forbidden response has a 4xx status code
func (o *UpdateOrgPreferencesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org preferences forbidden response has a 5xx status code
func (o *UpdateOrgPreferencesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update org preferences forbidden response a status code equal to that given
func (o *UpdateOrgPreferencesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update org preferences forbidden response
func (o *UpdateOrgPreferencesForbidden) Code() int {
	return 403
}

func (o *UpdateOrgPreferencesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesForbidden %s", 403, payload)
}

func (o *UpdateOrgPreferencesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesForbidden %s", 403, payload)
}

func (o *UpdateOrgPreferencesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgPreferencesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgPreferencesInternalServerError creates a UpdateOrgPreferencesInternalServerError with default headers values
func NewUpdateOrgPreferencesInternalServerError() *UpdateOrgPreferencesInternalServerError {
	return &UpdateOrgPreferencesInternalServerError{}
}

/*
UpdateOrgPreferencesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateOrgPreferencesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org preferences internal server error response has a 2xx status code
func (o *UpdateOrgPreferencesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org preferences internal server error response has a 3xx status code
func (o *UpdateOrgPreferencesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org preferences internal server error response has a 4xx status code
func (o *UpdateOrgPreferencesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update org preferences internal server error response has a 5xx status code
func (o *UpdateOrgPreferencesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update org preferences internal server error response a status code equal to that given
func (o *UpdateOrgPreferencesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update org preferences internal server error response
func (o *UpdateOrgPreferencesInternalServerError) Code() int {
	return 500
}

func (o *UpdateOrgPreferencesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesInternalServerError %s", 500, payload)
}

func (o *UpdateOrgPreferencesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /org/preferences][%d] updateOrgPreferencesInternalServerError %s", 500, payload)
}

func (o *UpdateOrgPreferencesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgPreferencesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
