// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewUpdateOrgQuotaParams creates a new UpdateOrgQuotaParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateOrgQuotaParams() *UpdateOrgQuotaParams {
	return &UpdateOrgQuotaParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateOrgQuotaParamsWithTimeout creates a new UpdateOrgQuotaParams object
// with the ability to set a timeout on a request.
func NewUpdateOrgQuotaParamsWithTimeout(timeout time.Duration) *UpdateOrgQuotaParams {
	return &UpdateOrgQuotaParams{
		timeout: timeout,
	}
}

// NewUpdateOrgQuotaParamsWithContext creates a new UpdateOrgQuotaParams object
// with the ability to set a context for a request.
func NewUpdateOrgQuotaParamsWithContext(ctx context.Context) *UpdateOrgQuotaParams {
	return &UpdateOrgQuotaParams{
		Context: ctx,
	}
}

// NewUpdateOrgQuotaParamsWithHTTPClient creates a new UpdateOrgQuotaParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateOrgQuotaParamsWithHTTPClient(client *http.Client) *UpdateOrgQuotaParams {
	return &UpdateOrgQuotaParams{
		HTTPClient: client,
	}
}

/*
UpdateOrgQuotaParams contains all the parameters to send to the API endpoint

	for the update org quota operation.

	Typically these are written to a http.Request.
*/
type UpdateOrgQuotaParams struct {

	// Body.
	Body *models.UpdateQuotaCmd

	// OrgID.
	//
	// Format: int64
	OrgID int64

	// QuotaTarget.
	QuotaTarget string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update org quota params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateOrgQuotaParams) WithDefaults() *UpdateOrgQuotaParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update org quota params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateOrgQuotaParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update org quota params
func (o *UpdateOrgQuotaParams) WithTimeout(timeout time.Duration) *UpdateOrgQuotaParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update org quota params
func (o *UpdateOrgQuotaParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update org quota params
func (o *UpdateOrgQuotaParams) WithContext(ctx context.Context) *UpdateOrgQuotaParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update org quota params
func (o *UpdateOrgQuotaParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update org quota params
func (o *UpdateOrgQuotaParams) WithHTTPClient(client *http.Client) *UpdateOrgQuotaParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update org quota params
func (o *UpdateOrgQuotaParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update org quota params
func (o *UpdateOrgQuotaParams) WithBody(body *models.UpdateQuotaCmd) *UpdateOrgQuotaParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update org quota params
func (o *UpdateOrgQuotaParams) SetBody(body *models.UpdateQuotaCmd) {
	o.Body = body
}

// WithOrgID adds the orgID to the update org quota params
func (o *UpdateOrgQuotaParams) WithOrgID(orgID int64) *UpdateOrgQuotaParams {
	o.SetOrgID(orgID)
	return o
}

// SetOrgID adds the orgId to the update org quota params
func (o *UpdateOrgQuotaParams) SetOrgID(orgID int64) {
	o.OrgID = orgID
}

// WithQuotaTarget adds the quotaTarget to the update org quota params
func (o *UpdateOrgQuotaParams) WithQuotaTarget(quotaTarget string) *UpdateOrgQuotaParams {
	o.SetQuotaTarget(quotaTarget)
	return o
}

// SetQuotaTarget adds the quotaTarget to the update org quota params
func (o *UpdateOrgQuotaParams) SetQuotaTarget(quotaTarget string) {
	o.QuotaTarget = quotaTarget
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateOrgQuotaParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param org_id
	if err := r.SetPathParam("org_id", swag.FormatInt64(o.OrgID)); err != nil {
		return err
	}

	// path param quota_target
	if err := r.SetPathParam("quota_target", o.QuotaTarget); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
