// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewExportMuteTimingsParams creates a new ExportMuteTimingsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewExportMuteTimingsParams() *ExportMuteTimingsParams {
	return &ExportMuteTimingsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewExportMuteTimingsParamsWithTimeout creates a new ExportMuteTimingsParams object
// with the ability to set a timeout on a request.
func NewExportMuteTimingsParamsWithTimeout(timeout time.Duration) *ExportMuteTimingsParams {
	return &ExportMuteTimingsParams{
		timeout: timeout,
	}
}

// NewExportMuteTimingsParamsWithContext creates a new ExportMuteTimingsParams object
// with the ability to set a context for a request.
func NewExportMuteTimingsParamsWithContext(ctx context.Context) *ExportMuteTimingsParams {
	return &ExportMuteTimingsParams{
		Context: ctx,
	}
}

// NewExportMuteTimingsParamsWithHTTPClient creates a new ExportMuteTimingsParams object
// with the ability to set a custom HTTPClient for a request.
func NewExportMuteTimingsParamsWithHTTPClient(client *http.Client) *ExportMuteTimingsParams {
	return &ExportMuteTimingsParams{
		HTTPClient: client,
	}
}

/*
ExportMuteTimingsParams contains all the parameters to send to the API endpoint

	for the export mute timings operation.

	Typically these are written to a http.Request.
*/
type ExportMuteTimingsParams struct {

	/* Download.

	   Whether to initiate a download of the file or not.
	*/
	Download *bool

	/* Format.

	   Format of the downloaded file. Supported yaml, json or hcl. Accept header can also be used, but the query parameter will take precedence.

	   Default: "yaml"
	*/
	Format *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the export mute timings params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportMuteTimingsParams) WithDefaults() *ExportMuteTimingsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the export mute timings params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportMuteTimingsParams) SetDefaults() {
	var (
		downloadDefault = bool(false)

		formatDefault = string("yaml")
	)

	val := ExportMuteTimingsParams{
		Download: &downloadDefault,
		Format:   &formatDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the export mute timings params
func (o *ExportMuteTimingsParams) WithTimeout(timeout time.Duration) *ExportMuteTimingsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the export mute timings params
func (o *ExportMuteTimingsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the export mute timings params
func (o *ExportMuteTimingsParams) WithContext(ctx context.Context) *ExportMuteTimingsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the export mute timings params
func (o *ExportMuteTimingsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the export mute timings params
func (o *ExportMuteTimingsParams) WithHTTPClient(client *http.Client) *ExportMuteTimingsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the export mute timings params
func (o *ExportMuteTimingsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDownload adds the download to the export mute timings params
func (o *ExportMuteTimingsParams) WithDownload(download *bool) *ExportMuteTimingsParams {
	o.SetDownload(download)
	return o
}

// SetDownload adds the download to the export mute timings params
func (o *ExportMuteTimingsParams) SetDownload(download *bool) {
	o.Download = download
}

// WithFormat adds the format to the export mute timings params
func (o *ExportMuteTimingsParams) WithFormat(format *string) *ExportMuteTimingsParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the export mute timings params
func (o *ExportMuteTimingsParams) SetFormat(format *string) {
	o.Format = format
}

// WriteToRequest writes these params to a swagger request
func (o *ExportMuteTimingsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Download != nil {

		// query param download
		var qrDownload bool

		if o.Download != nil {
			qrDownload = *o.Download
		}
		qDownload := swag.FormatBool(qrDownload)
		if qDownload != "" {

			if err := r.SetQueryParam("download", qDownload); err != nil {
				return err
			}
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
