// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPostContactpointsParams creates a new PostContactpointsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPostContactpointsParams() *PostContactpointsParams {
	return &PostContactpointsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPostContactpointsParamsWithTimeout creates a new PostContactpointsParams object
// with the ability to set a timeout on a request.
func NewPostContactpointsParamsWithTimeout(timeout time.Duration) *PostContactpointsParams {
	return &PostContactpointsParams{
		timeout: timeout,
	}
}

// NewPostContactpointsParamsWithContext creates a new PostContactpointsParams object
// with the ability to set a context for a request.
func NewPostContactpointsParamsWithContext(ctx context.Context) *PostContactpointsParams {
	return &PostContactpointsParams{
		Context: ctx,
	}
}

// NewPostContactpointsParamsWithHTTPClient creates a new PostContactpointsParams object
// with the ability to set a custom HTTPClient for a request.
func NewPostContactpointsParamsWithHTTPClient(client *http.Client) *PostContactpointsParams {
	return &PostContactpointsParams{
		HTTPClient: client,
	}
}

/*
PostContactpointsParams contains all the parameters to send to the API endpoint

	for the post contactpoints operation.

	Typically these are written to a http.Request.
*/
type PostContactpointsParams struct {

	// Body.
	Body *models.EmbeddedContactPoint

	// XDisableProvenance.
	XDisableProvenance *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the post contactpoints params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PostContactpointsParams) WithDefaults() *PostContactpointsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the post contactpoints params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PostContactpointsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the post contactpoints params
func (o *PostContactpointsParams) WithTimeout(timeout time.Duration) *PostContactpointsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the post contactpoints params
func (o *PostContactpointsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the post contactpoints params
func (o *PostContactpointsParams) WithContext(ctx context.Context) *PostContactpointsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the post contactpoints params
func (o *PostContactpointsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the post contactpoints params
func (o *PostContactpointsParams) WithHTTPClient(client *http.Client) *PostContactpointsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the post contactpoints params
func (o *PostContactpointsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the post contactpoints params
func (o *PostContactpointsParams) WithBody(body *models.EmbeddedContactPoint) *PostContactpointsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the post contactpoints params
func (o *PostContactpointsParams) SetBody(body *models.EmbeddedContactPoint) {
	o.Body = body
}

// WithXDisableProvenance adds the xDisableProvenance to the post contactpoints params
func (o *PostContactpointsParams) WithXDisableProvenance(xDisableProvenance *string) *PostContactpointsParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the post contactpoints params
func (o *PostContactpointsParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WriteToRequest writes these params to a swagger request
func (o *PostContactpointsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
