// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPutAlertRuleParams creates a new PutAlertRuleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutAlertRuleParams() *PutAlertRuleParams {
	return &PutAlertRuleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutAlertRuleParamsWithTimeout creates a new PutAlertRuleParams object
// with the ability to set a timeout on a request.
func NewPutAlertRuleParamsWithTimeout(timeout time.Duration) *PutAlertRuleParams {
	return &PutAlertRuleParams{
		timeout: timeout,
	}
}

// NewPutAlertRuleParamsWithContext creates a new PutAlertRuleParams object
// with the ability to set a context for a request.
func NewPutAlertRuleParamsWithContext(ctx context.Context) *PutAlertRuleParams {
	return &PutAlertRuleParams{
		Context: ctx,
	}
}

// NewPutAlertRuleParamsWithHTTPClient creates a new PutAlertRuleParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutAlertRuleParamsWithHTTPClient(client *http.Client) *PutAlertRuleParams {
	return &PutAlertRuleParams{
		HTTPClient: client,
	}
}

/*
PutAlertRuleParams contains all the parameters to send to the API endpoint

	for the put alert rule operation.

	Typically these are written to a http.Request.
*/
type PutAlertRuleParams struct {

	// Body.
	Body *models.ProvisionedAlertRule

	/* UID.

	   Alert rule UID
	*/
	UID string

	// XDisableProvenance.
	XDisableProvenance *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put alert rule params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutAlertRuleParams) WithDefaults() *PutAlertRuleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put alert rule params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutAlertRuleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put alert rule params
func (o *PutAlertRuleParams) WithTimeout(timeout time.Duration) *PutAlertRuleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put alert rule params
func (o *PutAlertRuleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put alert rule params
func (o *PutAlertRuleParams) WithContext(ctx context.Context) *PutAlertRuleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put alert rule params
func (o *PutAlertRuleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put alert rule params
func (o *PutAlertRuleParams) WithHTTPClient(client *http.Client) *PutAlertRuleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put alert rule params
func (o *PutAlertRuleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the put alert rule params
func (o *PutAlertRuleParams) WithBody(body *models.ProvisionedAlertRule) *PutAlertRuleParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the put alert rule params
func (o *PutAlertRuleParams) SetBody(body *models.ProvisionedAlertRule) {
	o.Body = body
}

// WithUID adds the uid to the put alert rule params
func (o *PutAlertRuleParams) WithUID(uid string) *PutAlertRuleParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the put alert rule params
func (o *PutAlertRuleParams) SetUID(uid string) {
	o.UID = uid
}

// WithXDisableProvenance adds the xDisableProvenance to the put alert rule params
func (o *PutAlertRuleParams) WithXDisableProvenance(xDisableProvenance *string) *PutAlertRuleParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the put alert rule params
func (o *PutAlertRuleParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WriteToRequest writes these params to a swagger request
func (o *PutAlertRuleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param UID
	if err := r.SetPathParam("UID", o.UID); err != nil {
		return err
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
