// Code generated by go-swagger; DO NOT EDIT.

package service_accounts

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SearchOrgServiceAccountsWithPagingReader is a Reader for the SearchOrgServiceAccountsWithPaging structure.
type SearchOrgServiceAccountsWithPagingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchOrgServiceAccountsWithPagingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchOrgServiceAccountsWithPagingOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSearchOrgServiceAccountsWithPagingUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSearchOrgServiceAccountsWithPagingForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSearchOrgServiceAccountsWithPagingInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /serviceaccounts/search] searchOrgServiceAccountsWithPaging", response, response.Code())
	}
}

// NewSearchOrgServiceAccountsWithPagingOK creates a SearchOrgServiceAccountsWithPagingOK with default headers values
func NewSearchOrgServiceAccountsWithPagingOK() *SearchOrgServiceAccountsWithPagingOK {
	return &SearchOrgServiceAccountsWithPagingOK{}
}

/*
SearchOrgServiceAccountsWithPagingOK describes a response with status code 200, with default header values.

(empty)
*/
type SearchOrgServiceAccountsWithPagingOK struct {
	Payload *models.SearchOrgServiceAccountsResult
}

// IsSuccess returns true when this search org service accounts with paging Ok response has a 2xx status code
func (o *SearchOrgServiceAccountsWithPagingOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search org service accounts with paging Ok response has a 3xx status code
func (o *SearchOrgServiceAccountsWithPagingOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search org service accounts with paging Ok response has a 4xx status code
func (o *SearchOrgServiceAccountsWithPagingOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search org service accounts with paging Ok response has a 5xx status code
func (o *SearchOrgServiceAccountsWithPagingOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search org service accounts with paging Ok response a status code equal to that given
func (o *SearchOrgServiceAccountsWithPagingOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search org service accounts with paging Ok response
func (o *SearchOrgServiceAccountsWithPagingOK) Code() int {
	return 200
}

func (o *SearchOrgServiceAccountsWithPagingOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingOk %s", 200, payload)
}

func (o *SearchOrgServiceAccountsWithPagingOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingOk %s", 200, payload)
}

func (o *SearchOrgServiceAccountsWithPagingOK) GetPayload() *models.SearchOrgServiceAccountsResult {
	return o.Payload
}

func (o *SearchOrgServiceAccountsWithPagingOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SearchOrgServiceAccountsResult)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchOrgServiceAccountsWithPagingUnauthorized creates a SearchOrgServiceAccountsWithPagingUnauthorized with default headers values
func NewSearchOrgServiceAccountsWithPagingUnauthorized() *SearchOrgServiceAccountsWithPagingUnauthorized {
	return &SearchOrgServiceAccountsWithPagingUnauthorized{}
}

/*
SearchOrgServiceAccountsWithPagingUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SearchOrgServiceAccountsWithPagingUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search org service accounts with paging unauthorized response has a 2xx status code
func (o *SearchOrgServiceAccountsWithPagingUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search org service accounts with paging unauthorized response has a 3xx status code
func (o *SearchOrgServiceAccountsWithPagingUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search org service accounts with paging unauthorized response has a 4xx status code
func (o *SearchOrgServiceAccountsWithPagingUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this search org service accounts with paging unauthorized response has a 5xx status code
func (o *SearchOrgServiceAccountsWithPagingUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this search org service accounts with paging unauthorized response a status code equal to that given
func (o *SearchOrgServiceAccountsWithPagingUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the search org service accounts with paging unauthorized response
func (o *SearchOrgServiceAccountsWithPagingUnauthorized) Code() int {
	return 401
}

func (o *SearchOrgServiceAccountsWithPagingUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingUnauthorized %s", 401, payload)
}

func (o *SearchOrgServiceAccountsWithPagingUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingUnauthorized %s", 401, payload)
}

func (o *SearchOrgServiceAccountsWithPagingUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchOrgServiceAccountsWithPagingUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchOrgServiceAccountsWithPagingForbidden creates a SearchOrgServiceAccountsWithPagingForbidden with default headers values
func NewSearchOrgServiceAccountsWithPagingForbidden() *SearchOrgServiceAccountsWithPagingForbidden {
	return &SearchOrgServiceAccountsWithPagingForbidden{}
}

/*
SearchOrgServiceAccountsWithPagingForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SearchOrgServiceAccountsWithPagingForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search org service accounts with paging forbidden response has a 2xx status code
func (o *SearchOrgServiceAccountsWithPagingForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search org service accounts with paging forbidden response has a 3xx status code
func (o *SearchOrgServiceAccountsWithPagingForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search org service accounts with paging forbidden response has a 4xx status code
func (o *SearchOrgServiceAccountsWithPagingForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this search org service accounts with paging forbidden response has a 5xx status code
func (o *SearchOrgServiceAccountsWithPagingForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this search org service accounts with paging forbidden response a status code equal to that given
func (o *SearchOrgServiceAccountsWithPagingForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the search org service accounts with paging forbidden response
func (o *SearchOrgServiceAccountsWithPagingForbidden) Code() int {
	return 403
}

func (o *SearchOrgServiceAccountsWithPagingForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingForbidden %s", 403, payload)
}

func (o *SearchOrgServiceAccountsWithPagingForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingForbidden %s", 403, payload)
}

func (o *SearchOrgServiceAccountsWithPagingForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchOrgServiceAccountsWithPagingForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchOrgServiceAccountsWithPagingInternalServerError creates a SearchOrgServiceAccountsWithPagingInternalServerError with default headers values
func NewSearchOrgServiceAccountsWithPagingInternalServerError() *SearchOrgServiceAccountsWithPagingInternalServerError {
	return &SearchOrgServiceAccountsWithPagingInternalServerError{}
}

/*
SearchOrgServiceAccountsWithPagingInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SearchOrgServiceAccountsWithPagingInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search org service accounts with paging internal server error response has a 2xx status code
func (o *SearchOrgServiceAccountsWithPagingInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search org service accounts with paging internal server error response has a 3xx status code
func (o *SearchOrgServiceAccountsWithPagingInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search org service accounts with paging internal server error response has a 4xx status code
func (o *SearchOrgServiceAccountsWithPagingInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this search org service accounts with paging internal server error response has a 5xx status code
func (o *SearchOrgServiceAccountsWithPagingInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this search org service accounts with paging internal server error response a status code equal to that given
func (o *SearchOrgServiceAccountsWithPagingInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the search org service accounts with paging internal server error response
func (o *SearchOrgServiceAccountsWithPagingInternalServerError) Code() int {
	return 500
}

func (o *SearchOrgServiceAccountsWithPagingInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingInternalServerError %s", 500, payload)
}

func (o *SearchOrgServiceAccountsWithPagingInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /serviceaccounts/search][%d] searchOrgServiceAccountsWithPagingInternalServerError %s", 500, payload)
}

func (o *SearchOrgServiceAccountsWithPagingInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchOrgServiceAccountsWithPagingInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
