// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SearchUsersReader is a Reader for the SearchUsers structure.
type SearchUsersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchUsersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchUsersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSearchUsersUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSearchUsersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSearchUsersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /users] searchUsers", response, response.Code())
	}
}

// NewSearchUsersOK creates a SearchUsersOK with default headers values
func NewSearchUsersOK() *SearchUsersOK {
	return &SearchUsersOK{}
}

/*
SearchUsersOK describes a response with status code 200, with default header values.

(empty)
*/
type SearchUsersOK struct {
	Payload []*models.UserSearchHitDTO
}

// IsSuccess returns true when this search users Ok response has a 2xx status code
func (o *SearchUsersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search users Ok response has a 3xx status code
func (o *SearchUsersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search users Ok response has a 4xx status code
func (o *SearchUsersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search users Ok response has a 5xx status code
func (o *SearchUsersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search users Ok response a status code equal to that given
func (o *SearchUsersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search users Ok response
func (o *SearchUsersOK) Code() int {
	return 200
}

func (o *SearchUsersOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersOk %s", 200, payload)
}

func (o *SearchUsersOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersOk %s", 200, payload)
}

func (o *SearchUsersOK) GetPayload() []*models.UserSearchHitDTO {
	return o.Payload
}

func (o *SearchUsersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchUsersUnauthorized creates a SearchUsersUnauthorized with default headers values
func NewSearchUsersUnauthorized() *SearchUsersUnauthorized {
	return &SearchUsersUnauthorized{}
}

/*
SearchUsersUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SearchUsersUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search users unauthorized response has a 2xx status code
func (o *SearchUsersUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search users unauthorized response has a 3xx status code
func (o *SearchUsersUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search users unauthorized response has a 4xx status code
func (o *SearchUsersUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this search users unauthorized response has a 5xx status code
func (o *SearchUsersUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this search users unauthorized response a status code equal to that given
func (o *SearchUsersUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the search users unauthorized response
func (o *SearchUsersUnauthorized) Code() int {
	return 401
}

func (o *SearchUsersUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersUnauthorized %s", 401, payload)
}

func (o *SearchUsersUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersUnauthorized %s", 401, payload)
}

func (o *SearchUsersUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchUsersUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchUsersForbidden creates a SearchUsersForbidden with default headers values
func NewSearchUsersForbidden() *SearchUsersForbidden {
	return &SearchUsersForbidden{}
}

/*
SearchUsersForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SearchUsersForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search users forbidden response has a 2xx status code
func (o *SearchUsersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search users forbidden response has a 3xx status code
func (o *SearchUsersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search users forbidden response has a 4xx status code
func (o *SearchUsersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this search users forbidden response has a 5xx status code
func (o *SearchUsersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this search users forbidden response a status code equal to that given
func (o *SearchUsersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the search users forbidden response
func (o *SearchUsersForbidden) Code() int {
	return 403
}

func (o *SearchUsersForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersForbidden %s", 403, payload)
}

func (o *SearchUsersForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersForbidden %s", 403, payload)
}

func (o *SearchUsersForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchUsersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchUsersInternalServerError creates a SearchUsersInternalServerError with default headers values
func NewSearchUsersInternalServerError() *SearchUsersInternalServerError {
	return &SearchUsersInternalServerError{}
}

/*
SearchUsersInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SearchUsersInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search users internal server error response has a 2xx status code
func (o *SearchUsersInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search users internal server error response has a 3xx status code
func (o *SearchUsersInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search users internal server error response has a 4xx status code
func (o *SearchUsersInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this search users internal server error response has a 5xx status code
func (o *SearchUsersInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this search users internal server error response a status code equal to that given
func (o *SearchUsersInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the search users internal server error response
func (o *SearchUsersInternalServerError) Code() int {
	return 500
}

func (o *SearchUsersInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersInternalServerError %s", 500, payload)
}

func (o *SearchUsersInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /users][%d] searchUsersInternalServerError %s", 500, payload)
}

func (o *SearchUsersInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchUsersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
