// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AlertRuleExport AlertRuleExport is the provisioned file export of models.AlertRule.
//
// swagger:model AlertRuleExport
type AlertRuleExport struct {

	// annotations
	Annotations map[string]string `json:"annotations,omitempty"`

	// condition
	Condition string `json:"condition,omitempty"`

	// dashboard Uid
	DashboardUID string `json:"dashboardUid,omitempty"`

	// data
	Data []*AlertQueryExport `json:"data"`

	// exec err state
	// Enum: [OK Alerting Error]
	ExecErrState string `json:"execErrState,omitempty"`

	// for
	For Duration `json:"for,omitempty"`

	// is paused
	IsPaused bool `json:"isPaused,omitempty"`

	// labels
	Labels map[string]string `json:"labels,omitempty"`

	// no data state
	// Enum: [Alerting NoData OK]
	NoDataState string `json:"noDataState,omitempty"`

	// notification settings
	NotificationSettings *AlertRuleNotificationSettingsExport `json:"notification_settings,omitempty"`

	// panel Id
	PanelID int64 `json:"panelId,omitempty"`

	// record
	Record *AlertRuleRecordExport `json:"record,omitempty"`

	// title
	Title string `json:"title,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`
}

// Validate validates this alert rule export
func (m *AlertRuleExport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateData(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExecErrState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoDataState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotificationSettings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRecord(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertRuleExport) validateData(formats strfmt.Registry) error {
	if swag.IsZero(m.Data) { // not required
		return nil
	}

	for i := 0; i < len(m.Data); i++ {
		if swag.IsZero(m.Data[i]) { // not required
			continue
		}

		if m.Data[i] != nil {
			if err := m.Data[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("data" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var alertRuleExportTypeExecErrStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["OK","Alerting","Error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		alertRuleExportTypeExecErrStatePropEnum = append(alertRuleExportTypeExecErrStatePropEnum, v)
	}
}

const (

	// AlertRuleExportExecErrStateOK captures enum value "OK"
	AlertRuleExportExecErrStateOK string = "OK"

	// AlertRuleExportExecErrStateAlerting captures enum value "Alerting"
	AlertRuleExportExecErrStateAlerting string = "Alerting"

	// AlertRuleExportExecErrStateError captures enum value "Error"
	AlertRuleExportExecErrStateError string = "Error"
)

// prop value enum
func (m *AlertRuleExport) validateExecErrStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, alertRuleExportTypeExecErrStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AlertRuleExport) validateExecErrState(formats strfmt.Registry) error {
	if swag.IsZero(m.ExecErrState) { // not required
		return nil
	}

	// value enum
	if err := m.validateExecErrStateEnum("execErrState", "body", m.ExecErrState); err != nil {
		return err
	}

	return nil
}

func (m *AlertRuleExport) validateFor(formats strfmt.Registry) error {
	if swag.IsZero(m.For) { // not required
		return nil
	}

	if err := m.For.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("for")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("for")
		}
		return err
	}

	return nil
}

var alertRuleExportTypeNoDataStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Alerting","NoData","OK"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		alertRuleExportTypeNoDataStatePropEnum = append(alertRuleExportTypeNoDataStatePropEnum, v)
	}
}

const (

	// AlertRuleExportNoDataStateAlerting captures enum value "Alerting"
	AlertRuleExportNoDataStateAlerting string = "Alerting"

	// AlertRuleExportNoDataStateNoData captures enum value "NoData"
	AlertRuleExportNoDataStateNoData string = "NoData"

	// AlertRuleExportNoDataStateOK captures enum value "OK"
	AlertRuleExportNoDataStateOK string = "OK"
)

// prop value enum
func (m *AlertRuleExport) validateNoDataStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, alertRuleExportTypeNoDataStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AlertRuleExport) validateNoDataState(formats strfmt.Registry) error {
	if swag.IsZero(m.NoDataState) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoDataStateEnum("noDataState", "body", m.NoDataState); err != nil {
		return err
	}

	return nil
}

func (m *AlertRuleExport) validateNotificationSettings(formats strfmt.Registry) error {
	if swag.IsZero(m.NotificationSettings) { // not required
		return nil
	}

	if m.NotificationSettings != nil {
		if err := m.NotificationSettings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notification_settings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("notification_settings")
			}
			return err
		}
	}

	return nil
}

func (m *AlertRuleExport) validateRecord(formats strfmt.Registry) error {
	if swag.IsZero(m.Record) { // not required
		return nil
	}

	if m.Record != nil {
		if err := m.Record.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("record")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("record")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this alert rule export based on the context it is used
func (m *AlertRuleExport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNotificationSettings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRecord(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertRuleExport) contextValidateData(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Data); i++ {

		if m.Data[i] != nil {

			if swag.IsZero(m.Data[i]) { // not required
				return nil
			}

			if err := m.Data[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("data" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AlertRuleExport) contextValidateFor(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.For) { // not required
		return nil
	}

	if err := m.For.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("for")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("for")
		}
		return err
	}

	return nil
}

func (m *AlertRuleExport) contextValidateNotificationSettings(ctx context.Context, formats strfmt.Registry) error {

	if m.NotificationSettings != nil {

		if swag.IsZero(m.NotificationSettings) { // not required
			return nil
		}

		if err := m.NotificationSettings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("notification_settings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("notification_settings")
			}
			return err
		}
	}

	return nil
}

func (m *AlertRuleExport) contextValidateRecord(ctx context.Context, formats strfmt.Registry) error {

	if m.Record != nil {

		if swag.IsZero(m.Record) { // not required
			return nil
		}

		if err := m.Record.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("record")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("record")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AlertRuleExport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AlertRuleExport) UnmarshalBinary(b []byte) error {
	var res AlertRuleExport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
