// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PublicDashboard public dashboard
//
// swagger:model PublicDashboard
type PublicDashboard struct {

	// access token
	AccessToken string `json:"accessToken,omitempty"`

	// annotations enabled
	AnnotationsEnabled bool `json:"annotationsEnabled,omitempty"`

	// created at
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"createdAt,omitempty"`

	// created by
	CreatedBy int64 `json:"createdBy,omitempty"`

	// dashboard Uid
	DashboardUID string `json:"dashboardUid,omitempty"`

	// is enabled
	IsEnabled bool `json:"isEnabled,omitempty"`

	// recipients
	Recipients []*EmailDTO `json:"recipients"`

	// share
	Share ShareType `json:"share,omitempty"`

	// time selection enabled
	TimeSelectionEnabled bool `json:"timeSelectionEnabled,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`

	// updated at
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updatedAt,omitempty"`

	// updated by
	UpdatedBy int64 `json:"updatedBy,omitempty"`
}

// Validate validates this public dashboard
func (m *PublicDashboard) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRecipients(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShare(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublicDashboard) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("createdAt", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *PublicDashboard) validateRecipients(formats strfmt.Registry) error {
	if swag.IsZero(m.Recipients) { // not required
		return nil
	}

	for i := 0; i < len(m.Recipients); i++ {
		if swag.IsZero(m.Recipients[i]) { // not required
			continue
		}

		if m.Recipients[i] != nil {
			if err := m.Recipients[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("recipients" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("recipients" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicDashboard) validateShare(formats strfmt.Registry) error {
	if swag.IsZero(m.Share) { // not required
		return nil
	}

	if err := m.Share.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("share")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("share")
		}
		return err
	}

	return nil
}

func (m *PublicDashboard) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updatedAt", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this public dashboard based on the context it is used
func (m *PublicDashboard) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRecipients(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShare(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublicDashboard) contextValidateRecipients(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Recipients); i++ {

		if m.Recipients[i] != nil {

			if swag.IsZero(m.Recipients[i]) { // not required
				return nil
			}

			if err := m.Recipients[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("recipients" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("recipients" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicDashboard) contextValidateShare(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Share) { // not required
		return nil
	}

	if err := m.Share.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("share")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("share")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PublicDashboard) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PublicDashboard) UnmarshalBinary(b []byte) error {
	var res PublicDashboard
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
