// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TimeIntervalItem time interval item
//
// swagger:model TimeIntervalItem
type TimeIntervalItem struct {

	// days of month
	DaysOfMonth []string `json:"days_of_month"`

	// location
	Location string `json:"location,omitempty"`

	// months
	Months []string `json:"months"`

	// times
	Times []*TimeIntervalTimeRange `json:"times"`

	// weekdays
	Weekdays []string `json:"weekdays"`

	// years
	Years []string `json:"years"`
}

// Validate validates this time interval item
func (m *TimeIntervalItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTimes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TimeIntervalItem) validateTimes(formats strfmt.Registry) error {
	if swag.IsZero(m.Times) { // not required
		return nil
	}

	for i := 0; i < len(m.Times); i++ {
		if swag.IsZero(m.Times[i]) { // not required
			continue
		}

		if m.Times[i] != nil {
			if err := m.Times[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("times" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("times" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this time interval item based on the context it is used
func (m *TimeIntervalItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTimes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TimeIntervalItem) contextValidateTimes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Times); i++ {

		if m.Times[i] != nil {

			if swag.IsZero(m.Times[i]) { // not required
				return nil
			}

			if err := m.Times[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("times" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("times" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TimeIntervalItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TimeIntervalItem) UnmarshalBinary(b []byte) error {
	var res TimeIntervalItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
