// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// WechatConfig WechatConfig configures notifications via Wechat.
//
// swagger:model WechatConfig
type WechatConfig struct {

	// agent id
	AgentID string `json:"agent_id,omitempty"`

	// api secret
	APISecret Secret `json:"api_secret,omitempty"`

	// api url
	APIURL *URL `json:"api_url,omitempty"`

	// corp id
	CorpID string `json:"corp_id,omitempty"`

	// http config
	HTTPConfig *HTTPClientConfig `json:"http_config,omitempty"`

	// message
	Message string `json:"message,omitempty"`

	// message type
	MessageType string `json:"message_type,omitempty"`

	// send resolved
	SendResolved bool `json:"send_resolved,omitempty"`

	// to party
	ToParty string `json:"to_party,omitempty"`

	// to tag
	ToTag string `json:"to_tag,omitempty"`

	// to user
	ToUser string `json:"to_user,omitempty"`
}

// Validate validates this wechat config
func (m *WechatConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPISecret(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAPIURL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPConfig(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WechatConfig) validateAPISecret(formats strfmt.Registry) error {
	if swag.IsZero(m.APISecret) { // not required
		return nil
	}

	if err := m.APISecret.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("api_secret")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("api_secret")
		}
		return err
	}

	return nil
}

func (m *WechatConfig) validateAPIURL(formats strfmt.Registry) error {
	if swag.IsZero(m.APIURL) { // not required
		return nil
	}

	if m.APIURL != nil {
		if err := m.APIURL.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("api_url")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("api_url")
			}
			return err
		}
	}

	return nil
}

func (m *WechatConfig) validateHTTPConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPConfig) { // not required
		return nil
	}

	if m.HTTPConfig != nil {
		if err := m.HTTPConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_config")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this wechat config based on the context it is used
func (m *WechatConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAPISecret(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAPIURL(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WechatConfig) contextValidateAPISecret(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.APISecret) { // not required
		return nil
	}

	if err := m.APISecret.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("api_secret")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("api_secret")
		}
		return err
	}

	return nil
}

func (m *WechatConfig) contextValidateAPIURL(ctx context.Context, formats strfmt.Registry) error {

	if m.APIURL != nil {

		if swag.IsZero(m.APIURL) { // not required
			return nil
		}

		if err := m.APIURL.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("api_url")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("api_url")
			}
			return err
		}
	}

	return nil
}

func (m *WechatConfig) contextValidateHTTPConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.HTTPConfig != nil {

		if swag.IsZero(m.HTTPConfig) { // not required
			return nil
		}

		if err := m.HTTPConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_config")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WechatConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WechatConfig) UnmarshalBinary(b []byte) error {
	var res WechatConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
