// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Updates findings with the new values provided in the request.
type UpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer that generated the findings to update.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// A client token.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The IDs of the findings to update.
	Ids []string `locationName:"ids" type:"list"`

	// The ARN of the resource identified in the finding.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The state represents the action to take to update the finding Status. Use
	// ARCHIVE to change an Active finding to an Archived finding. Use ACTIVE to
	// change an Archived finding to an Active finding.
	//
	// Status is a required field
	Status FindingStatusUpdate `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFindingsInput"}

	if s.AnalyzerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerArn"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AnalyzerArn != nil {
		v := *s.AnalyzerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "analyzerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ids != nil {
		v := s.Ids

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ids", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type UpdateFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest returns a request value for making API operation for
// Access Analyzer.
//
// Updates the status for the specified findings.
//
//    // Example sending a request using UpdateFindingsRequest.
//    req := client.UpdateFindingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateFindings
func (c *Client) UpdateFindingsRequest(input *UpdateFindingsInput) UpdateFindingsRequest {
	op := &aws.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PUT",
		HTTPPath:   "/finding",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	req := c.newRequest(op, input, &UpdateFindingsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateFindingsRequest{Request: req, Input: input, Copy: c.UpdateFindingsRequest}
}

// UpdateFindingsRequest is the request type for the
// UpdateFindings API operation.
type UpdateFindingsRequest struct {
	*aws.Request
	Input *UpdateFindingsInput
	Copy  func(*UpdateFindingsInput) UpdateFindingsRequest
}

// Send marshals and sends the UpdateFindings API request.
func (r UpdateFindingsRequest) Send(ctx context.Context) (*UpdateFindingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFindingsResponse{
		UpdateFindingsOutput: r.Request.Data.(*UpdateFindingsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFindingsResponse is the response type for the
// UpdateFindings API operation.
type UpdateFindingsResponse struct {
	*UpdateFindingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFindings request.
func (r *UpdateFindingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
