// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acm

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains metadata about an ACM certificate. This structure is returned in
// the response to a DescribeCertificate request.
type CertificateDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate. For more information about
	// ARNs, see Amazon Resource Names (ARNs) and AWS Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	CertificateArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) of the ACM PCA private certificate authority
	// (CA) that issued the certificate. This has the following format:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	CertificateAuthorityArn *string `min:"20" type:"string"`

	// The time at which the certificate was requested. This value exists only when
	// the certificate type is AMAZON_ISSUED.
	CreatedAt *time.Time `type:"timestamp"`

	// The fully qualified domain name for the certificate, such as www.example.com
	// or example.com.
	DomainName *string `min:"1" type:"string"`

	// Contains information about the initial validation of each domain name that
	// occurs as a result of the RequestCertificate request. This field exists only
	// when the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []DomainValidation `min:"1" type:"list"`

	// Contains a list of Extended Key Usage X.509 v3 extension objects. Each object
	// specifies a purpose for which the certificate public key can be used and
	// consists of a name and an object identifier (OID).
	ExtendedKeyUsages []ExtendedKeyUsage `type:"list"`

	// The reason the certificate request failed. This value exists only when the
	// certificate status is FAILED. For more information, see Certificate Request
	// Failed (https://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed)
	// in the AWS Certificate Manager User Guide.
	FailureReason FailureReason `type:"string" enum:"true"`

	// The date and time at which the certificate was imported. This value exists
	// only when the certificate type is IMPORTED.
	ImportedAt *time.Time `type:"timestamp"`

	// A list of ARNs for the AWS resources that are using the certificate. A certificate
	// can be used by multiple AWS resources.
	InUseBy []string `type:"list"`

	// The time at which the certificate was issued. This value exists only when
	// the certificate type is AMAZON_ISSUED.
	IssuedAt *time.Time `type:"timestamp"`

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string `type:"string"`

	// The algorithm that was used to generate the public-private key pair.
	KeyAlgorithm KeyAlgorithm `type:"string" enum:"true"`

	// A list of Key Usage X.509 v3 extension objects. Each object is a string value
	// that identifies the purpose of the public key contained in the certificate.
	// Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION,
	// and more.
	KeyUsages []KeyUsage `type:"list"`

	// The time after which the certificate is not valid.
	NotAfter *time.Time `type:"timestamp"`

	// The time before which the certificate is not valid.
	NotBefore *time.Time `type:"timestamp"`

	// Value that specifies whether to add the certificate to a transparency log.
	// Certificate transparency makes it possible to detect SSL certificates that
	// have been mistakenly or maliciously issued. A browser might respond to certificate
	// that has not been logged by showing an error message. The logs are cryptographically
	// secure.
	Options *CertificateOptions `type:"structure"`

	// Specifies whether the certificate is eligible for renewal. At this time,
	// only exported private certificates can be renewed with the RenewCertificate
	// command.
	RenewalEligibility RenewalEligibility `type:"string" enum:"true"`

	// Contains information about the status of ACM's managed renewal (https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
	// for the certificate. This field exists only when the certificate type is
	// AMAZON_ISSUED.
	RenewalSummary *RenewalSummary `type:"structure"`

	// The reason the certificate was revoked. This value exists only when the certificate
	// status is REVOKED.
	RevocationReason RevocationReason `type:"string" enum:"true"`

	// The time at which the certificate was revoked. This value exists only when
	// the certificate status is REVOKED.
	RevokedAt *time.Time `type:"timestamp"`

	// The serial number of the certificate.
	Serial *string `type:"string"`

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string `type:"string"`

	// The status of the certificate.
	Status CertificateStatus `type:"string" enum:"true"`

	// The name of the entity that is associated with the public key contained in
	// the certificate.
	Subject *string `type:"string"`

	// One or more domain names (subject alternative names) included in the certificate.
	// This list contains the domain names that are bound to the public key that
	// is contained in the certificate. The subject alternative names include the
	// canonical domain name (CN) of the certificate and additional domain names
	// that can be used to connect to the website.
	SubjectAlternativeNames []string `min:"1" type:"list"`

	// The source of the certificate. For certificates provided by ACM, this value
	// is AMAZON_ISSUED. For certificates that you imported with ImportCertificate,
	// this value is IMPORTED. ACM does not provide managed renewal (https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
	// for imported certificates. For more information about the differences between
	// certificates that you import and those that ACM provides, see Importing Certificates
	// (https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the AWS Certificate Manager User Guide.
	Type CertificateType `type:"string" enum:"true"`
}

// String returns the string representation
func (s CertificateDetail) String() string {
	return awsutil.Prettify(s)
}

// Structure that contains options for your certificate. Currently, you can
// use this only to specify whether to opt in to or out of certificate transparency
// logging. Some browsers require that public certificates issued for your domain
// be recorded in a log. Certificates that are not logged typically generate
// a browser error. Transparency makes it possible for you to detect SSL/TLS
// certificates that have been mistakenly or maliciously issued for your domain.
// For general information, see Certificate Transparency Logging (https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency).
type CertificateOptions struct {
	_ struct{} `type:"structure"`

	// You can opt out of certificate transparency logging by specifying the DISABLED
	// option. Opt in by specifying ENABLED.
	CertificateTransparencyLoggingPreference CertificateTransparencyLoggingPreference `type:"string" enum:"true"`
}

// String returns the string representation
func (s CertificateOptions) String() string {
	return awsutil.Prettify(s)
}

// This structure is returned in the response object of ListCertificates action.
type CertificateSummary struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the certificate. This is of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	CertificateArn *string `min:"20" type:"string"`

	// Fully qualified domain name (FQDN), such as www.example.com or example.com,
	// for the certificate.
	DomainName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CertificateSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the validation of each domain name in the certificate.
type DomainValidation struct {
	_ struct{} `type:"structure"`

	// A fully qualified domain name (FQDN) in the certificate. For example, www.example.com
	// or example.com.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// Contains the CNAME record that you add to your DNS database for domain validation.
	// For more information, see Use DNS to Validate Domain Ownership (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html).
	ResourceRecord *ResourceRecord `type:"structure"`

	// The domain name that ACM used to send domain validation emails.
	ValidationDomain *string `min:"1" type:"string"`

	// A list of email addresses that ACM used to send domain validation emails.
	ValidationEmails []string `type:"list"`

	// Specifies the domain validation method.
	ValidationMethod ValidationMethod `type:"string" enum:"true"`

	// The validation status of the domain name. This can be one of the following
	// values:
	//
	//    * PENDING_VALIDATION
	//
	//    * SUCCESS
	//
	//    * FAILED
	ValidationStatus DomainStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DomainValidation) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the domain names that you want ACM to use to send
// you emails that enable you to validate domain ownership.
type DomainValidationOption struct {
	_ struct{} `type:"structure"`

	// A fully qualified domain name (FQDN) in the certificate request.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The domain name that you want ACM to use to send you validation emails. This
	// domain name is the suffix of the email addresses that you want ACM to use.
	// This must be the same as the DomainName value or a superdomain of the DomainName
	// value. For example, if you request a certificate for testing.example.com,
	// you can specify example.com for this value. In that case, ACM sends domain
	// validation emails to the following five addresses:
	//
	//    * admin@example.com
	//
	//    * administrator@example.com
	//
	//    * hostmaster@example.com
	//
	//    * postmaster@example.com
	//
	//    * webmaster@example.com
	//
	// ValidationDomain is a required field
	ValidationDomain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DomainValidationOption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainValidationOption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DomainValidationOption"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 1))
	}

	if s.ValidationDomain == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationDomain"))
	}
	if s.ValidationDomain != nil && len(*s.ValidationDomain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationDomain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Extended Key Usage X.509 v3 extension defines one or more purposes for
// which the public key can be used. This is in addition to or in place of the
// basic purposes specified by the Key Usage extension.
type ExtendedKeyUsage struct {
	_ struct{} `type:"structure"`

	// The name of an Extended Key Usage value.
	Name ExtendedKeyUsageName `type:"string" enum:"true"`

	// An object identifier (OID) for the extension value. OIDs are strings of numbers
	// separated by periods. The following OIDs are defined in RFC 3280 and RFC
	// 5280.
	//
	//    * 1.3.6.1.5.5.7.3.1 (TLS_WEB_SERVER_AUTHENTICATION)
	//
	//    * 1.3.6.1.5.5.7.3.2 (TLS_WEB_CLIENT_AUTHENTICATION)
	//
	//    * 1.3.6.1.5.5.7.3.3 (CODE_SIGNING)
	//
	//    * 1.3.6.1.5.5.7.3.4 (EMAIL_PROTECTION)
	//
	//    * 1.3.6.1.5.5.7.3.8 (TIME_STAMPING)
	//
	//    * 1.3.6.1.5.5.7.3.9 (OCSP_SIGNING)
	//
	//    * 1.3.6.1.5.5.7.3.5 (IPSEC_END_SYSTEM)
	//
	//    * 1.3.6.1.5.5.7.3.6 (IPSEC_TUNNEL)
	//
	//    * 1.3.6.1.5.5.7.3.7 (IPSEC_USER)
	OID *string `type:"string"`
}

// String returns the string representation
func (s ExtendedKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// This structure can be used in the ListCertificates action to filter the output
// of the certificate list.
type Filters struct {
	_ struct{} `type:"structure"`

	// Specify one or more ExtendedKeyUsage extension values.
	ExtendedKeyUsage []ExtendedKeyUsageName `locationName:"extendedKeyUsage" type:"list"`

	// Specify one or more algorithms that can be used to generate key pairs.
	//
	// Default filtering returns only RSA_2048 certificates. To return other certificate
	// types, provide the desired type signatures in a comma-separated list. For
	// example, "keyTypes": ["RSA_2048,RSA_4096"] returns both RSA_2048 and RSA_4096
	// certificates.
	KeyTypes []KeyAlgorithm `locationName:"keyTypes" type:"list"`

	// Specify one or more KeyUsage extension values.
	KeyUsage []KeyUsageName `locationName:"keyUsage" type:"list"`
}

// String returns the string representation
func (s Filters) String() string {
	return awsutil.Prettify(s)
}

// The Key Usage X.509 v3 extension defines the purpose of the public key contained
// in the certificate.
type KeyUsage struct {
	_ struct{} `type:"structure"`

	// A string value that contains a Key Usage extension name.
	Name KeyUsageName `type:"string" enum:"true"`
}

// String returns the string representation
func (s KeyUsage) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the status of ACM's managed renewal (https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
// for the certificate. This structure exists only when the certificate type
// is AMAZON_ISSUED.
type RenewalSummary struct {
	_ struct{} `type:"structure"`

	// Contains information about the validation of each domain name in the certificate,
	// as it pertains to ACM's managed renewal (https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html).
	// This is different from the initial validation that occurs as a result of
	// the RequestCertificate request. This field exists only when the certificate
	// type is AMAZON_ISSUED.
	//
	// DomainValidationOptions is a required field
	DomainValidationOptions []DomainValidation `min:"1" type:"list" required:"true"`

	// The status of ACM's managed renewal (https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
	// of the certificate.
	//
	// RenewalStatus is a required field
	RenewalStatus RenewalStatus `type:"string" required:"true" enum:"true"`

	// The reason that a renewal request was unsuccessful.
	RenewalStatusReason FailureReason `type:"string" enum:"true"`

	// The time at which the renewal summary was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s RenewalSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains a DNS record value that you can use to can use to validate ownership
// or control of a domain. This is used by the DescribeCertificate action.
type ResourceRecord struct {
	_ struct{} `type:"structure"`

	// The name of the DNS record to create in your domain. This is supplied by
	// ACM.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The type of DNS record. Currently this can be CNAME.
	//
	// Type is a required field
	Type RecordType `type:"string" required:"true" enum:"true"`

	// The value of the CNAME record to add to your DNS database. This is supplied
	// by ACM.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// A key-value pair that identifies or specifies metadata about an ACM resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
