// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateBusinessReportScheduleInput struct {
	_ struct{} `type:"structure"`

	// The format of the generated report (individual CSV files or zipped files
	// of individual files).
	Format BusinessReportFormat `type:"string" enum:"true"`

	// The recurrence of the reports.
	Recurrence *BusinessReportRecurrence `type:"structure"`

	// The S3 location of the output reports.
	S3BucketName *string `type:"string"`

	// The S3 key where the report is delivered.
	S3KeyPrefix *string `type:"string"`

	// The ARN of the business report schedule.
	//
	// ScheduleArn is a required field
	ScheduleArn *string `type:"string" required:"true"`

	// The name identifier of the schedule.
	ScheduleName *string `type:"string"`
}

// String returns the string representation
func (s UpdateBusinessReportScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBusinessReportScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateBusinessReportScheduleInput"}

	if s.ScheduleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateBusinessReportScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateBusinessReportScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateBusinessReportSchedule = "UpdateBusinessReportSchedule"

// UpdateBusinessReportScheduleRequest returns a request value for making API operation for
// Alexa For Business.
//
// Updates the configuration of the report delivery schedule with the specified
// schedule ARN.
//
//    // Example sending a request using UpdateBusinessReportScheduleRequest.
//    req := client.UpdateBusinessReportScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule
func (c *Client) UpdateBusinessReportScheduleRequest(input *UpdateBusinessReportScheduleInput) UpdateBusinessReportScheduleRequest {
	op := &aws.Operation{
		Name:       opUpdateBusinessReportSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBusinessReportScheduleInput{}
	}

	req := c.newRequest(op, input, &UpdateBusinessReportScheduleOutput{})
	return UpdateBusinessReportScheduleRequest{Request: req, Input: input, Copy: c.UpdateBusinessReportScheduleRequest}
}

// UpdateBusinessReportScheduleRequest is the request type for the
// UpdateBusinessReportSchedule API operation.
type UpdateBusinessReportScheduleRequest struct {
	*aws.Request
	Input *UpdateBusinessReportScheduleInput
	Copy  func(*UpdateBusinessReportScheduleInput) UpdateBusinessReportScheduleRequest
}

// Send marshals and sends the UpdateBusinessReportSchedule API request.
func (r UpdateBusinessReportScheduleRequest) Send(ctx context.Context) (*UpdateBusinessReportScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateBusinessReportScheduleResponse{
		UpdateBusinessReportScheduleOutput: r.Request.Data.(*UpdateBusinessReportScheduleOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateBusinessReportScheduleResponse is the response type for the
// UpdateBusinessReportSchedule API operation.
type UpdateBusinessReportScheduleResponse struct {
	*UpdateBusinessReportScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateBusinessReportSchedule request.
func (r *UpdateBusinessReportScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
