// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the directory configuration.
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDirectoryConfigInput"}

	if s.DirectoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDirectoryConfig = "DeleteDirectoryConfig"

// DeleteDirectoryConfigRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Deletes the specified Directory Config object from AppStream 2.0. This object
// includes the information required to join streaming instances to an Active
// Directory domain.
//
//    // Example sending a request using DeleteDirectoryConfigRequest.
//    req := client.DeleteDirectoryConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig
func (c *Client) DeleteDirectoryConfigRequest(input *DeleteDirectoryConfigInput) DeleteDirectoryConfigRequest {
	op := &aws.Operation{
		Name:       opDeleteDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectoryConfigInput{}
	}

	req := c.newRequest(op, input, &DeleteDirectoryConfigOutput{})
	return DeleteDirectoryConfigRequest{Request: req, Input: input, Copy: c.DeleteDirectoryConfigRequest}
}

// DeleteDirectoryConfigRequest is the request type for the
// DeleteDirectoryConfig API operation.
type DeleteDirectoryConfigRequest struct {
	*aws.Request
	Input *DeleteDirectoryConfigInput
	Copy  func(*DeleteDirectoryConfigInput) DeleteDirectoryConfigRequest
}

// Send marshals and sends the DeleteDirectoryConfig API request.
func (r DeleteDirectoryConfigRequest) Send(ctx context.Context) (*DeleteDirectoryConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDirectoryConfigResponse{
		DeleteDirectoryConfigOutput: r.Request.Data.(*DeleteDirectoryConfigOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDirectoryConfigResponse is the response type for the
// DeleteDirectoryConfig API operation.
type DeleteDirectoryConfigResponse struct {
	*DeleteDirectoryConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDirectoryConfig request.
func (r *DeleteDirectoryConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
