// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package batchiface provides an interface to enable mocking the AWS Batch service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package batchiface

import (
	"github.com/aws/aws-sdk-go-v2/service/batch"
)

// ClientAPI provides an interface to enable mocking the
// batch.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Batch.
//    func myFunc(svc batchiface.ClientAPI) bool {
//        // Make svc.CancelJob request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := batch.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        batchiface.ClientPI
//    }
//    func (m *mockClientClient) CancelJob(input *batch.CancelJobInput) (*batch.CancelJobOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CancelJobRequest(*batch.CancelJobInput) batch.CancelJobRequest

	CreateComputeEnvironmentRequest(*batch.CreateComputeEnvironmentInput) batch.CreateComputeEnvironmentRequest

	CreateJobQueueRequest(*batch.CreateJobQueueInput) batch.CreateJobQueueRequest

	DeleteComputeEnvironmentRequest(*batch.DeleteComputeEnvironmentInput) batch.DeleteComputeEnvironmentRequest

	DeleteJobQueueRequest(*batch.DeleteJobQueueInput) batch.DeleteJobQueueRequest

	DeregisterJobDefinitionRequest(*batch.DeregisterJobDefinitionInput) batch.DeregisterJobDefinitionRequest

	DescribeComputeEnvironmentsRequest(*batch.DescribeComputeEnvironmentsInput) batch.DescribeComputeEnvironmentsRequest

	DescribeJobDefinitionsRequest(*batch.DescribeJobDefinitionsInput) batch.DescribeJobDefinitionsRequest

	DescribeJobQueuesRequest(*batch.DescribeJobQueuesInput) batch.DescribeJobQueuesRequest

	DescribeJobsRequest(*batch.DescribeJobsInput) batch.DescribeJobsRequest

	ListJobsRequest(*batch.ListJobsInput) batch.ListJobsRequest

	RegisterJobDefinitionRequest(*batch.RegisterJobDefinitionInput) batch.RegisterJobDefinitionRequest

	SubmitJobRequest(*batch.SubmitJobInput) batch.SubmitJobRequest

	TerminateJobRequest(*batch.TerminateJobInput) batch.TerminateJobRequest

	UpdateComputeEnvironmentRequest(*batch.UpdateComputeEnvironmentInput) batch.UpdateComputeEnvironmentRequest

	UpdateJobQueueRequest(*batch.UpdateJobQueueInput) batch.UpdateJobQueueRequest
}

var _ ClientAPI = (*batch.Client)(nil)
