// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package budgets

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request of UpdateNotification
type UpdateNotificationInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose notification you want
	// to update.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose notification you want to update.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The updated notification to be associated with a budget.
	//
	// NewNotification is a required field
	NewNotification *Notification `type:"structure" required:"true"`

	// The previous notification that is associated with a budget.
	//
	// OldNotification is a required field
	OldNotification *Notification `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotificationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateNotificationInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountId", 12))
	}

	if s.BudgetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BudgetName", 1))
	}

	if s.NewNotification == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewNotification"))
	}

	if s.OldNotification == nil {
		invalidParams.Add(aws.NewErrParamRequired("OldNotification"))
	}
	if s.NewNotification != nil {
		if err := s.NewNotification.Validate(); err != nil {
			invalidParams.AddNested("NewNotification", err.(aws.ErrInvalidParams))
		}
	}
	if s.OldNotification != nil {
		if err := s.OldNotification.Validate(); err != nil {
			invalidParams.AddNested("OldNotification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response of UpdateNotification
type UpdateNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateNotification = "UpdateNotification"

// UpdateNotificationRequest returns a request value for making API operation for
// AWS Budgets.
//
// Updates a notification.
//
//    // Example sending a request using UpdateNotificationRequest.
//    req := client.UpdateNotificationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateNotificationRequest(input *UpdateNotificationInput) UpdateNotificationRequest {
	op := &aws.Operation{
		Name:       opUpdateNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotificationInput{}
	}

	req := c.newRequest(op, input, &UpdateNotificationOutput{})
	return UpdateNotificationRequest{Request: req, Input: input, Copy: c.UpdateNotificationRequest}
}

// UpdateNotificationRequest is the request type for the
// UpdateNotification API operation.
type UpdateNotificationRequest struct {
	*aws.Request
	Input *UpdateNotificationInput
	Copy  func(*UpdateNotificationInput) UpdateNotificationRequest
}

// Send marshals and sends the UpdateNotification API request.
func (r UpdateNotificationRequest) Send(ctx context.Context) (*UpdateNotificationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateNotificationResponse{
		UpdateNotificationOutput: r.Request.Data.(*UpdateNotificationOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateNotificationResponse is the response type for the
// UpdateNotification API operation.
type UpdateNotificationResponse struct {
	*UpdateNotificationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateNotification request.
func (r *UpdateNotificationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
