// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVoiceConnectorInput"}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector details.
	VoiceConnector *VoiceConnector `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VoiceConnector != nil {
		v := s.VoiceConnector

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceConnector", v, metadata)
	}
	return nil
}

const opGetVoiceConnector = "GetVoiceConnector"

// GetVoiceConnectorRequest returns a request value for making API operation for
// Amazon Chime.
//
// Retrieves details for the specified Amazon Chime Voice Connector, such as
// timestamps, name, outbound host, and encryption requirements.
//
//    // Example sending a request using GetVoiceConnectorRequest.
//    req := client.GetVoiceConnectorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnector
func (c *Client) GetVoiceConnectorRequest(input *GetVoiceConnectorInput) GetVoiceConnectorRequest {
	op := &aws.Operation{
		Name:       opGetVoiceConnector,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &GetVoiceConnectorInput{}
	}

	req := c.newRequest(op, input, &GetVoiceConnectorOutput{})
	return GetVoiceConnectorRequest{Request: req, Input: input, Copy: c.GetVoiceConnectorRequest}
}

// GetVoiceConnectorRequest is the request type for the
// GetVoiceConnector API operation.
type GetVoiceConnectorRequest struct {
	*aws.Request
	Input *GetVoiceConnectorInput
	Copy  func(*GetVoiceConnectorInput) GetVoiceConnectorRequest
}

// Send marshals and sends the GetVoiceConnector API request.
func (r GetVoiceConnectorRequest) Send(ctx context.Context) (*GetVoiceConnectorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVoiceConnectorResponse{
		GetVoiceConnectorOutput: r.Request.Data.(*GetVoiceConnectorOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVoiceConnectorResponse is the response type for the
// GetVoiceConnector API operation.
type GetVoiceConnectorResponse struct {
	*GetVoiceConnectorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVoiceConnector request.
func (r *GetVoiceConnectorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
