// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudhsmiface provides an interface to enable mocking the Amazon CloudHSM service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudhsmiface

import (
	"github.com/aws/aws-sdk-go-v2/service/cloudhsm"
)

// ClientAPI provides an interface to enable mocking the
// cloudhsm.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // CloudHSM.
//    func myFunc(svc cloudhsmiface.ClientAPI) bool {
//        // Make svc.AddTagsToResource request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := cloudhsm.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        cloudhsmiface.ClientPI
//    }
//    func (m *mockClientClient) AddTagsToResource(input *cloudhsm.AddTagsToResourceInput) (*cloudhsm.AddTagsToResourceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddTagsToResourceRequest(*cloudhsm.AddTagsToResourceInput) cloudhsm.AddTagsToResourceRequest

	CreateHapgRequest(*cloudhsm.CreateHapgInput) cloudhsm.CreateHapgRequest

	CreateHsmRequest(*cloudhsm.CreateHsmInput) cloudhsm.CreateHsmRequest

	CreateLunaClientRequest(*cloudhsm.CreateLunaClientInput) cloudhsm.CreateLunaClientRequest

	DeleteHapgRequest(*cloudhsm.DeleteHapgInput) cloudhsm.DeleteHapgRequest

	DeleteHsmRequest(*cloudhsm.DeleteHsmInput) cloudhsm.DeleteHsmRequest

	DeleteLunaClientRequest(*cloudhsm.DeleteLunaClientInput) cloudhsm.DeleteLunaClientRequest

	DescribeHapgRequest(*cloudhsm.DescribeHapgInput) cloudhsm.DescribeHapgRequest

	DescribeHsmRequest(*cloudhsm.DescribeHsmInput) cloudhsm.DescribeHsmRequest

	DescribeLunaClientRequest(*cloudhsm.DescribeLunaClientInput) cloudhsm.DescribeLunaClientRequest

	GetConfigRequest(*cloudhsm.GetConfigInput) cloudhsm.GetConfigRequest

	ListAvailableZonesRequest(*cloudhsm.ListAvailableZonesInput) cloudhsm.ListAvailableZonesRequest

	ListHapgsRequest(*cloudhsm.ListHapgsInput) cloudhsm.ListHapgsRequest

	ListHsmsRequest(*cloudhsm.ListHsmsInput) cloudhsm.ListHsmsRequest

	ListLunaClientsRequest(*cloudhsm.ListLunaClientsInput) cloudhsm.ListLunaClientsRequest

	ListTagsForResourceRequest(*cloudhsm.ListTagsForResourceInput) cloudhsm.ListTagsForResourceRequest

	ModifyHapgRequest(*cloudhsm.ModifyHapgInput) cloudhsm.ModifyHapgRequest

	ModifyHsmRequest(*cloudhsm.ModifyHsmInput) cloudhsm.ModifyHsmRequest

	ModifyLunaClientRequest(*cloudhsm.ModifyLunaClientInput) cloudhsm.ModifyLunaClientRequest

	RemoveTagsFromResourceRequest(*cloudhsm.RemoveTagsFromResourceInput) cloudhsm.RemoveTagsFromResourceRequest
}

var _ ClientAPI = (*cloudhsm.Client)(nil)
