// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListReportsForReportGroupInput struct {
	_ struct{} `type:"structure"`

	// A ReportFilter object used to filter the returned reports.
	Filter *ReportFilter `locationName:"filter" type:"structure"`

	// The maximum number of paginated reports in this report group returned per
	// response. Use nextToken to iterate pages in the list of returned Report objects.
	// The default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// During a previous call, the maximum number of items that can be returned
	// is the value specified in maxResults. If there more items in the list, then
	// a unique string called a nextToken is returned. To get the next batch of
	// items in the list, call this operation again, adding the next token to the
	// call. To get all of the items in the list, keep calling this operation with
	// each subsequent next token that is returned, until no more next tokens are
	// returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN of the report group for which you want to return report ARNs.
	//
	// ReportGroupArn is a required field
	ReportGroupArn *string `locationName:"reportGroupArn" type:"string" required:"true"`

	// Use to specify whether the results are returned in ascending or descending
	// order.
	SortOrder SortOrderType `locationName:"sortOrder" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListReportsForReportGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReportsForReportGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListReportsForReportGroupInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ReportGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReportGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListReportsForReportGroupOutput struct {
	_ struct{} `type:"structure"`

	// During a previous call, the maximum number of items that can be returned
	// is the value specified in maxResults. If there more items in the list, then
	// a unique string called a nextToken is returned. To get the next batch of
	// items in the list, call this operation again, adding the next token to the
	// call. To get all of the items in the list, keep calling this operation with
	// each subsequent next token that is returned, until no more next tokens are
	// returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of returned report group ARNs.
	Reports []string `locationName:"reports" min:"1" type:"list"`
}

// String returns the string representation
func (s ListReportsForReportGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opListReportsForReportGroup = "ListReportsForReportGroup"

// ListReportsForReportGroupRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Returns a list of ARNs for the reports that belong to a ReportGroup.
//
//    // Example sending a request using ListReportsForReportGroupRequest.
//    req := client.ListReportsForReportGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportsForReportGroup
func (c *Client) ListReportsForReportGroupRequest(input *ListReportsForReportGroupInput) ListReportsForReportGroupRequest {
	op := &aws.Operation{
		Name:       opListReportsForReportGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReportsForReportGroupInput{}
	}

	req := c.newRequest(op, input, &ListReportsForReportGroupOutput{})
	return ListReportsForReportGroupRequest{Request: req, Input: input, Copy: c.ListReportsForReportGroupRequest}
}

// ListReportsForReportGroupRequest is the request type for the
// ListReportsForReportGroup API operation.
type ListReportsForReportGroupRequest struct {
	*aws.Request
	Input *ListReportsForReportGroupInput
	Copy  func(*ListReportsForReportGroupInput) ListReportsForReportGroupRequest
}

// Send marshals and sends the ListReportsForReportGroup API request.
func (r ListReportsForReportGroupRequest) Send(ctx context.Context) (*ListReportsForReportGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListReportsForReportGroupResponse{
		ListReportsForReportGroupOutput: r.Request.Data.(*ListReportsForReportGroupOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListReportsForReportGroupResponse is the response type for the
// ListReportsForReportGroup API operation.
type ListReportsForReportGroupResponse struct {
	*ListReportsForReportGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListReportsForReportGroup request.
func (r *ListReportsForReportGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
