// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarnotifications

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListTargetsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to return information by service or resource type. Valid
	// filters include target type, target address, and target status.
	//
	// A filter with the same name can appear more than once when used with OR statements.
	// Filters with different names should be applied with AND statements.
	Filters []ListTargetsFilter `type:"list"`

	// A non-negative integer used to limit the number of returned results. The
	// maximum number of results that can be returned is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTargetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Filters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListTargetsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that can be used in a request to return the next batch
	// of results.
	NextToken *string `type:"string"`

	// The list of notification rule targets.
	Targets []TargetSummary `type:"list"`
}

// String returns the string representation
func (s ListTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTargetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Targets != nil {
		v := s.Targets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Targets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListTargets = "ListTargets"

// ListTargetsRequest returns a request value for making API operation for
// AWS CodeStar Notifications.
//
// Returns a list of the notification rule targets for an AWS account.
//
//    // Example sending a request using ListTargetsRequest.
//    req := client.ListTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTargets
func (c *Client) ListTargetsRequest(input *ListTargetsInput) ListTargetsRequest {
	op := &aws.Operation{
		Name:       opListTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/listTargets",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetsInput{}
	}

	req := c.newRequest(op, input, &ListTargetsOutput{})
	return ListTargetsRequest{Request: req, Input: input, Copy: c.ListTargetsRequest}
}

// ListTargetsRequest is the request type for the
// ListTargets API operation.
type ListTargetsRequest struct {
	*aws.Request
	Input *ListTargetsInput
	Copy  func(*ListTargetsInput) ListTargetsRequest
}

// Send marshals and sends the ListTargets API request.
func (r ListTargetsRequest) Send(ctx context.Context) (*ListTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTargetsResponse{
		ListTargetsOutput: r.Request.Data.(*ListTargetsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTargetsRequestPaginator returns a paginator for ListTargets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTargetsRequest(input)
//   p := codestarnotifications.NewListTargetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTargetsPaginator(req ListTargetsRequest) ListTargetsPaginator {
	return ListTargetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTargetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTargetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTargetsPaginator struct {
	aws.Pager
}

func (p *ListTargetsPaginator) CurrentPage() *ListTargetsOutput {
	return p.Pager.CurrentPage().(*ListTargetsOutput)
}

// ListTargetsResponse is the response type for the
// ListTargets API operation.
type ListTargetsResponse struct {
	*ListTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTargets request.
func (r *ListTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
