// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Configuration options for configure Cognito streams.
type CognitoStreams struct {
	_ struct{} `type:"structure"`

	// The ARN of the role Amazon Cognito can assume in order to publish to the
	// stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke
	// PutRecord on your Cognito stream.
	RoleArn *string `min:"20" type:"string"`

	// The name of the Cognito stream to receive updates. This stream must be in
	// the developers account and in the same region as the identity pool.
	StreamName *string `min:"1" type:"string"`

	// Status of the Cognito streams. Valid values are:
	// ENABLED - Streaming of updates to identity pool is enabled.
	//
	// DISABLED - Streaming of updates to identity pool is disabled. Bulk publish
	// will also fail if StreamingStatus is DISABLED.
	StreamingStatus StreamingStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s CognitoStreams) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoStreams) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CognitoStreams"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CognitoStreams) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StreamingStatus) > 0 {
		v := s.StreamingStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamingStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A collection of data for an identity pool. An identity pool can have multiple
// datasets. A dataset is per identity and can be general or associated with
// a particular entity in an application (like a saved game). Datasets are automatically
// created if they don't exist. Data is synced by dataset, and a dataset can
// hold up to 1MB of key-value pairs.
type Dataset struct {
	_ struct{} `type:"structure"`

	// Date on which the dataset was created.
	CreationDate *time.Time `type:"timestamp"`

	// Total size in bytes of the records in this dataset.
	DataStorage *int64 `type:"long"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	DatasetName *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityId *string `min:"1" type:"string"`

	// The device that made the last change to this dataset.
	LastModifiedBy *string `type:"string"`

	// Date when the dataset was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Number of records in this dataset.
	NumRecords *int64 `type:"long"`
}

// String returns the string representation
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Dataset) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DataStorage != nil {
		v := *s.DataStorage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataStorage", protocol.Int64Value(v), metadata)
	}
	if s.DatasetName != nil {
		v := *s.DatasetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DatasetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityId != nil {
		v := *s.IdentityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.NumRecords != nil {
		v := *s.NumRecords

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumRecords", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Usage information for the identity pool.
type IdentityPoolUsage struct {
	_ struct{} `type:"structure"`

	// Data storage information for the identity pool.
	DataStorage *int64 `type:"long"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`

	// Date on which the identity pool was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Number of sync sessions for the identity pool.
	SyncSessionsCount *int64 `type:"long"`
}

// String returns the string representation
func (s IdentityPoolUsage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IdentityPoolUsage) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataStorage != nil {
		v := *s.DataStorage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataStorage", protocol.Int64Value(v), metadata)
	}
	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.SyncSessionsCount != nil {
		v := *s.SyncSessionsCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SyncSessionsCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Usage information for the identity.
type IdentityUsage struct {
	_ struct{} `type:"structure"`

	// Total data storage for this identity.
	DataStorage *int64 `type:"long"`

	// Number of datasets for the identity.
	DatasetCount *int64 `type:"integer"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityId *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`

	// Date on which the identity was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s IdentityUsage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IdentityUsage) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataStorage != nil {
		v := *s.DataStorage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataStorage", protocol.Int64Value(v), metadata)
	}
	if s.DatasetCount != nil {
		v := *s.DatasetCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DatasetCount", protocol.Int64Value(v), metadata)
	}
	if s.IdentityId != nil {
		v := *s.IdentityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Configuration options to be applied to the identity pool.
type PushSync struct {
	_ struct{} `type:"structure"`

	// List of SNS platform application ARNs that could be used by clients.
	ApplicationArns []string `type:"list"`

	// A role configured to allow Cognito to call SNS on behalf of the developer.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s PushSync) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PushSync) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PushSync"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PushSync) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationArns != nil {
		v := s.ApplicationArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ApplicationArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The basic data structure of a dataset.
type Record struct {
	_ struct{} `type:"structure"`

	// The last modified date of the client device.
	DeviceLastModifiedDate *time.Time `type:"timestamp"`

	// The key for the record.
	Key *string `min:"1" type:"string"`

	// The user/device that made the last change to this record.
	LastModifiedBy *string `type:"string"`

	// The date on which the record was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The server sync count for this record.
	SyncCount *int64 `type:"long"`

	// The value for the record.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Record) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceLastModifiedDate != nil {
		v := *s.DeviceLastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceLastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.SyncCount != nil {
		v := *s.SyncCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SyncCount", protocol.Int64Value(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An update operation for a record.
type RecordPatch struct {
	_ struct{} `type:"structure"`

	// The last modified date of the client device.
	DeviceLastModifiedDate *time.Time `type:"timestamp"`

	// The key associated with the record patch.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An operation, either replace or remove.
	//
	// Op is a required field
	Op Operation `type:"string" required:"true" enum:"true"`

	// Last known server sync count for this record. Set to 0 if unknown.
	//
	// SyncCount is a required field
	SyncCount *int64 `type:"long" required:"true"`

	// The value associated with the record patch.
	Value *string `type:"string"`
}

// String returns the string representation
func (s RecordPatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordPatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordPatch"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if len(s.Op) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Op"))
	}

	if s.SyncCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("SyncCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecordPatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceLastModifiedDate != nil {
		v := *s.DeviceLastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceLastModifiedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Op) > 0 {
		v := s.Op

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Op", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SyncCount != nil {
		v := *s.SyncCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SyncCount", protocol.Int64Value(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
