// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopPHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PHI detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopPHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPHIDetectionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopPHIDetectionJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopPHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PHI detection job that was stopped.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StopPHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopPHIDetectionJob = "StopPHIDetectionJob"

// StopPHIDetectionJobRequest returns a request value for making API operation for
// AWS Comprehend Medical.
//
// Stops a protected health information (PHI) detection job in progress.
//
//    // Example sending a request using StopPHIDetectionJobRequest.
//    req := client.StopPHIDetectionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob
func (c *Client) StopPHIDetectionJobRequest(input *StopPHIDetectionJobInput) StopPHIDetectionJobRequest {
	op := &aws.Operation{
		Name:       opStopPHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPHIDetectionJobInput{}
	}

	req := c.newRequest(op, input, &StopPHIDetectionJobOutput{})
	return StopPHIDetectionJobRequest{Request: req, Input: input, Copy: c.StopPHIDetectionJobRequest}
}

// StopPHIDetectionJobRequest is the request type for the
// StopPHIDetectionJob API operation.
type StopPHIDetectionJobRequest struct {
	*aws.Request
	Input *StopPHIDetectionJobInput
	Copy  func(*StopPHIDetectionJobInput) StopPHIDetectionJobRequest
}

// Send marshals and sends the StopPHIDetectionJob API request.
func (r StopPHIDetectionJobRequest) Send(ctx context.Context) (*StopPHIDetectionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopPHIDetectionJobResponse{
		StopPHIDetectionJobOutput: r.Request.Data.(*StopPHIDetectionJobOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopPHIDetectionJobResponse is the response type for the
// StopPHIDetectionJob API operation.
type StopPHIDetectionJobResponse struct {
	*StopPHIDetectionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopPHIDetectionJob request.
func (r *StopPHIDetectionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
