// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeRemediationExecutionStatusInput struct {
	_ struct{} `type:"structure"`

	// A list of AWS Config rule names.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of RemediationExecutionStatuses returned on each page.
	// The default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of resource keys to be processed with the current request. Each element
	// in the list consists of the resource type and resource ID.
	ResourceKeys []ResourceKey `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeRemediationExecutionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationExecutionStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRemediationExecutionStatusInput"}

	if s.ConfigRuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeRemediationExecutionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of remediation execution statuses objects.
	RemediationExecutionStatuses []RemediationExecutionStatus `type:"list"`
}

// String returns the string representation
func (s DescribeRemediationExecutionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeRemediationExecutionStatus = "DescribeRemediationExecutionStatus"

// DescribeRemediationExecutionStatusRequest returns a request value for making API operation for
// AWS Config.
//
// Provides a detailed view of a Remediation Execution for a set of resources
// including state, timestamps for when steps for the remediation execution
// occur, and any error messages for steps that have failed. When you specify
// the limit and the next token, you receive a paginated response.
//
//    // Example sending a request using DescribeRemediationExecutionStatusRequest.
//    req := client.DescribeRemediationExecutionStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus
func (c *Client) DescribeRemediationExecutionStatusRequest(input *DescribeRemediationExecutionStatusInput) DescribeRemediationExecutionStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeRemediationExecutionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRemediationExecutionStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeRemediationExecutionStatusOutput{})
	return DescribeRemediationExecutionStatusRequest{Request: req, Input: input, Copy: c.DescribeRemediationExecutionStatusRequest}
}

// DescribeRemediationExecutionStatusRequest is the request type for the
// DescribeRemediationExecutionStatus API operation.
type DescribeRemediationExecutionStatusRequest struct {
	*aws.Request
	Input *DescribeRemediationExecutionStatusInput
	Copy  func(*DescribeRemediationExecutionStatusInput) DescribeRemediationExecutionStatusRequest
}

// Send marshals and sends the DescribeRemediationExecutionStatus API request.
func (r DescribeRemediationExecutionStatusRequest) Send(ctx context.Context) (*DescribeRemediationExecutionStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRemediationExecutionStatusResponse{
		DescribeRemediationExecutionStatusOutput: r.Request.Data.(*DescribeRemediationExecutionStatusOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeRemediationExecutionStatusRequestPaginator returns a paginator for DescribeRemediationExecutionStatus.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeRemediationExecutionStatusRequest(input)
//   p := configservice.NewDescribeRemediationExecutionStatusRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeRemediationExecutionStatusPaginator(req DescribeRemediationExecutionStatusRequest) DescribeRemediationExecutionStatusPaginator {
	return DescribeRemediationExecutionStatusPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeRemediationExecutionStatusInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeRemediationExecutionStatusPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeRemediationExecutionStatusPaginator struct {
	aws.Pager
}

func (p *DescribeRemediationExecutionStatusPaginator) CurrentPage() *DescribeRemediationExecutionStatusOutput {
	return p.Pager.CurrentPage().(*DescribeRemediationExecutionStatusOutput)
}

// DescribeRemediationExecutionStatusResponse is the response type for the
// DescribeRemediationExecutionStatus API operation.
type DescribeRemediationExecutionStatusResponse struct {
	*DescribeRemediationExecutionStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRemediationExecutionStatus request.
func (r *DescribeRemediationExecutionStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
