// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteRevisionInput struct {
	_ struct{} `type:"structure"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRevisionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRevisionInput"}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRevisionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteRevisionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRevisionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteRevision = "DeleteRevision"

// DeleteRevisionRequest returns a request value for making API operation for
// AWS Data Exchange.
//
// This operation deletes a revision.
//
//    // Example sending a request using DeleteRevisionRequest.
//    req := client.DeleteRevisionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/DeleteRevision
func (c *Client) DeleteRevisionRequest(input *DeleteRevisionInput) DeleteRevisionRequest {
	op := &aws.Operation{
		Name:       opDeleteRevision,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
	}

	if input == nil {
		input = &DeleteRevisionInput{}
	}

	req := c.newRequest(op, input, &DeleteRevisionOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteRevisionRequest{Request: req, Input: input, Copy: c.DeleteRevisionRequest}
}

// DeleteRevisionRequest is the request type for the
// DeleteRevision API operation.
type DeleteRevisionRequest struct {
	*aws.Request
	Input *DeleteRevisionInput
	Copy  func(*DeleteRevisionInput) DeleteRevisionRequest
}

// Send marshals and sends the DeleteRevision API request.
func (r DeleteRevisionRequest) Send(ctx context.Context) (*DeleteRevisionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRevisionResponse{
		DeleteRevisionOutput: r.Request.Data.(*DeleteRevisionOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRevisionResponse is the response type for the
// DeleteRevision API operation.
type DeleteRevisionResponse struct {
	*DeleteRevisionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRevision request.
func (r *DeleteRevisionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
