// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListBackupsInput struct {
	_ struct{} `type:"structure"`

	// The backups from the table specified by BackupType are listed.
	//
	// Where BackupType can be:
	//
	//    * USER - On-demand backup created by you.
	//
	//    * SYSTEM - On-demand backup automatically created by DynamoDB.
	//
	//    * ALL - All types of on-demand backups (USER and SYSTEM).
	BackupType BackupTypeFilter `type:"string" enum:"true"`

	// LastEvaluatedBackupArn is the Amazon Resource Name (ARN) of the backup last
	// evaluated when the current page of results was returned, inclusive of the
	// current page of results. This value may be specified as the ExclusiveStartBackupArn
	// of a new ListBackups operation in order to fetch the next page of results.
	ExclusiveStartBackupArn *string `min:"37" type:"string"`

	// Maximum number of backups to return at once.
	Limit *int64 `min:"1" type:"integer"`

	// The backups from the table specified by TableName are listed.
	TableName *string `min:"3" type:"string"`

	// Only backups created after this time are listed. TimeRangeLowerBound is inclusive.
	TimeRangeLowerBound *time.Time `type:"timestamp"`

	// Only backups created before this time are listed. TimeRangeUpperBound is
	// exclusive.
	TimeRangeUpperBound *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ListBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBackupsInput"}
	if s.ExclusiveStartBackupArn != nil && len(*s.ExclusiveStartBackupArn) < 37 {
		invalidParams.Add(aws.NewErrParamMinLen("ExclusiveStartBackupArn", 37))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListBackupsOutput struct {
	_ struct{} `type:"structure"`

	// List of BackupSummary objects.
	BackupSummaries []BackupSummary `type:"list"`

	// The ARN of the backup last evaluated when the current page of results was
	// returned, inclusive of the current page of results. This value may be specified
	// as the ExclusiveStartBackupArn of a new ListBackups operation in order to
	// fetch the next page of results.
	//
	// If LastEvaluatedBackupArn is empty, then the last page of results has been
	// processed and there are no more results to be retrieved.
	//
	// If LastEvaluatedBackupArn is not empty, this may or may not indicate that
	// there is more data to be returned. All results are guaranteed to have been
	// returned if and only if no value for LastEvaluatedBackupArn is returned.
	LastEvaluatedBackupArn *string `min:"37" type:"string"`
}

// String returns the string representation
func (s ListBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBackups = "ListBackups"

// ListBackupsRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// List backups associated with an AWS account. To list backups for a given
// table, specify TableName. ListBackups returns a paginated list of results
// with at most 1 MB worth of items in a page. You can also specify a limit
// for the maximum number of entries to be returned in a page.
//
// In the request, start time is inclusive, but end time is exclusive. Note
// that these limits are for the time at which the original backup was requested.
//
// You can call ListBackups a maximum of five times per second.
//
//    // Example sending a request using ListBackupsRequest.
//    req := client.ListBackupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListBackups
func (c *Client) ListBackupsRequest(input *ListBackupsInput) ListBackupsRequest {
	op := &aws.Operation{
		Name:       opListBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBackupsInput{}
	}

	req := c.newRequest(op, input, &ListBackupsOutput{})
	return ListBackupsRequest{Request: req, Input: input, Copy: c.ListBackupsRequest}
}

// ListBackupsRequest is the request type for the
// ListBackups API operation.
type ListBackupsRequest struct {
	*aws.Request
	Input *ListBackupsInput
	Copy  func(*ListBackupsInput) ListBackupsRequest
}

// Send marshals and sends the ListBackups API request.
func (r ListBackupsRequest) Send(ctx context.Context) (*ListBackupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBackupsResponse{
		ListBackupsOutput: r.Request.Data.(*ListBackupsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListBackupsResponse is the response type for the
// ListBackups API operation.
type ListBackupsResponse struct {
	*ListBackupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBackups request.
func (r *ListBackupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
