// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeBundleTasksInput struct {
	_ struct{} `type:"structure"`

	// The bundle task IDs.
	//
	// Default: Describes all your bundle tasks.
	BundleIds []string `locationName:"BundleId" locationNameList:"BundleId" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The filters.
	//
	//    * bundle-id - The ID of the bundle task.
	//
	//    * error-code - If the task failed, the error code returned.
	//
	//    * error-message - If the task failed, the error message returned.
	//
	//    * instance-id - The ID of the instance.
	//
	//    * progress - The level of task completion, as a percentage (for example,
	//    20%).
	//
	//    * s3-bucket - The Amazon S3 bucket to store the AMI.
	//
	//    * s3-prefix - The beginning of the AMI name.
	//
	//    * start-time - The time the task started (for example, 2013-09-15T17:15:20.000Z).
	//
	//    * state - The state of the task (pending | waiting-for-shutdown | bundling
	//    | storing | cancelling | complete | failed).
	//
	//    * update-time - The time of the most recent update for the task.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`
}

// String returns the string representation
func (s DescribeBundleTasksInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeBundleTasksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundle tasks.
	BundleTasks []BundleTask `locationName:"bundleInstanceTasksSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeBundleTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeBundleTasks = "DescribeBundleTasks"

// DescribeBundleTasksRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the specified bundle tasks or all of your bundle tasks.
//
// Completed bundle tasks are listed for only a limited time. If your bundle
// task is no longer in the list, you can still register an AMI from it. Just
// use RegisterImage with the Amazon S3 bucket name and image manifest name
// you provided to the bundle task.
//
//    // Example sending a request using DescribeBundleTasksRequest.
//    req := client.DescribeBundleTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks
func (c *Client) DescribeBundleTasksRequest(input *DescribeBundleTasksInput) DescribeBundleTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeBundleTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBundleTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeBundleTasksOutput{})
	return DescribeBundleTasksRequest{Request: req, Input: input, Copy: c.DescribeBundleTasksRequest}
}

// DescribeBundleTasksRequest is the request type for the
// DescribeBundleTasks API operation.
type DescribeBundleTasksRequest struct {
	*aws.Request
	Input *DescribeBundleTasksInput
	Copy  func(*DescribeBundleTasksInput) DescribeBundleTasksRequest
}

// Send marshals and sends the DescribeBundleTasks API request.
func (r DescribeBundleTasksRequest) Send(ctx context.Context) (*DescribeBundleTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeBundleTasksResponse{
		DescribeBundleTasksOutput: r.Request.Data.(*DescribeBundleTasksOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeBundleTasksResponse is the response type for the
// DescribeBundleTasks API operation.
type DescribeBundleTasksResponse struct {
	*DescribeBundleTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeBundleTasks request.
func (r *DescribeBundleTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
