// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterTransitGatewayMulticastGroupMembersInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IP address assigned to the transit gateway multicast group.
	GroupIpAddress *string `type:"string"`

	// The group members' network interface IDs to register with the transit gateway
	// multicast group.
	NetworkInterfaceIds []string `locationNameList:"item" type:"list"`

	// The ID of the transit gateway multicast domain.
	TransitGatewayMulticastDomainId *string `type:"string"`
}

// String returns the string representation
func (s RegisterTransitGatewayMulticastGroupMembersInput) String() string {
	return awsutil.Prettify(s)
}

type RegisterTransitGatewayMulticastGroupMembersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the registered transit gateway multicast group members.
	RegisteredMulticastGroupMembers *TransitGatewayMulticastRegisteredGroupMembers `locationName:"registeredMulticastGroupMembers" type:"structure"`
}

// String returns the string representation
func (s RegisterTransitGatewayMulticastGroupMembersOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterTransitGatewayMulticastGroupMembers = "RegisterTransitGatewayMulticastGroupMembers"

// RegisterTransitGatewayMulticastGroupMembersRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Registers members (network interfaces) with the transit gateway multicast
// group. A member is a network interface associated with a supported EC2 instance
// that receives multicast traffic. For information about supported instances,
// see Multicast Consideration (https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits)
// in Amazon VPC Transit Gateways.
//
// After you add the members, use SearchTransitGatewayMulticastGroups (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html)
// to verify that the members were added to the transit gateway multicast group.
//
//    // Example sending a request using RegisterTransitGatewayMulticastGroupMembersRequest.
//    req := client.RegisterTransitGatewayMulticastGroupMembersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RegisterTransitGatewayMulticastGroupMembers
func (c *Client) RegisterTransitGatewayMulticastGroupMembersRequest(input *RegisterTransitGatewayMulticastGroupMembersInput) RegisterTransitGatewayMulticastGroupMembersRequest {
	op := &aws.Operation{
		Name:       opRegisterTransitGatewayMulticastGroupMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTransitGatewayMulticastGroupMembersInput{}
	}

	req := c.newRequest(op, input, &RegisterTransitGatewayMulticastGroupMembersOutput{})
	return RegisterTransitGatewayMulticastGroupMembersRequest{Request: req, Input: input, Copy: c.RegisterTransitGatewayMulticastGroupMembersRequest}
}

// RegisterTransitGatewayMulticastGroupMembersRequest is the request type for the
// RegisterTransitGatewayMulticastGroupMembers API operation.
type RegisterTransitGatewayMulticastGroupMembersRequest struct {
	*aws.Request
	Input *RegisterTransitGatewayMulticastGroupMembersInput
	Copy  func(*RegisterTransitGatewayMulticastGroupMembersInput) RegisterTransitGatewayMulticastGroupMembersRequest
}

// Send marshals and sends the RegisterTransitGatewayMulticastGroupMembers API request.
func (r RegisterTransitGatewayMulticastGroupMembersRequest) Send(ctx context.Context) (*RegisterTransitGatewayMulticastGroupMembersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterTransitGatewayMulticastGroupMembersResponse{
		RegisterTransitGatewayMulticastGroupMembersOutput: r.Request.Data.(*RegisterTransitGatewayMulticastGroupMembersOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterTransitGatewayMulticastGroupMembersResponse is the response type for the
// RegisterTransitGatewayMulticastGroupMembers API operation.
type RegisterTransitGatewayMulticastGroupMembersResponse struct {
	*RegisterTransitGatewayMulticastGroupMembersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterTransitGatewayMulticastGroupMembers request.
func (r *RegisterTransitGatewayMulticastGroupMembersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
