// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateClusterSettingsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to modify the settings for.
	//
	// Cluster is a required field
	Cluster *string `locationName:"cluster" type:"string" required:"true"`

	// The setting to use by default for a cluster. This parameter is used to enable
	// CloudWatch Container Insights for a cluster. If this value is specified,
	// it will override the containerInsights value set with PutAccountSetting or
	// PutAccountSettingDefault.
	//
	// Settings is a required field
	Settings []ClusterSetting `locationName:"settings" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateClusterSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateClusterSettingsInput"}

	if s.Cluster == nil {
		invalidParams.Add(aws.NewErrParamRequired("Cluster"))
	}

	if s.Settings == nil {
		invalidParams.Add(aws.NewErrParamRequired("Settings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateClusterSettingsOutput struct {
	_ struct{} `type:"structure"`

	// A regional grouping of one or more container instances on which you can run
	// task requests. Each account receives a default cluster the first time you
	// use the Amazon ECS service, but you may also create other clusters. Clusters
	// may contain more than one instance type simultaneously.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation
func (s UpdateClusterSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateClusterSettings = "UpdateClusterSettings"

// UpdateClusterSettingsRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Modifies the settings to use for a cluster.
//
//    // Example sending a request using UpdateClusterSettingsRequest.
//    req := client.UpdateClusterSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/UpdateClusterSettings
func (c *Client) UpdateClusterSettingsRequest(input *UpdateClusterSettingsInput) UpdateClusterSettingsRequest {
	op := &aws.Operation{
		Name:       opUpdateClusterSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClusterSettingsInput{}
	}

	req := c.newRequest(op, input, &UpdateClusterSettingsOutput{})
	return UpdateClusterSettingsRequest{Request: req, Input: input, Copy: c.UpdateClusterSettingsRequest}
}

// UpdateClusterSettingsRequest is the request type for the
// UpdateClusterSettings API operation.
type UpdateClusterSettingsRequest struct {
	*aws.Request
	Input *UpdateClusterSettingsInput
	Copy  func(*UpdateClusterSettingsInput) UpdateClusterSettingsRequest
}

// Send marshals and sends the UpdateClusterSettings API request.
func (r UpdateClusterSettingsRequest) Send(ctx context.Context) (*UpdateClusterSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateClusterSettingsResponse{
		UpdateClusterSettingsOutput: r.Request.Data.(*UpdateClusterSettingsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateClusterSettingsResponse is the response type for the
// UpdateClusterSettings API operation.
type UpdateClusterSettingsResponse struct {
	*UpdateClusterSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateClusterSettings request.
func (r *UpdateClusterSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
