// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CompleteMigrationInput struct {
	_ struct{} `type:"structure"`

	// Forces the migration to stop without ensuring that data is in sync. It is
	// recommended to use this option only to abort the migration and not recommended
	// when application wants to continue migration to ElastiCache.
	Force *bool `type:"boolean"`

	// The ID of the replication group to which data is being migrated.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMigrationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMigrationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompleteMigrationInput"}

	if s.ReplicationGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CompleteMigrationOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s CompleteMigrationOutput) String() string {
	return awsutil.Prettify(s)
}

const opCompleteMigration = "CompleteMigration"

// CompleteMigrationRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Complete the migration of data.
//
//    // Example sending a request using CompleteMigrationRequest.
//    req := client.CompleteMigrationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CompleteMigration
func (c *Client) CompleteMigrationRequest(input *CompleteMigrationInput) CompleteMigrationRequest {
	op := &aws.Operation{
		Name:       opCompleteMigration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteMigrationInput{}
	}

	req := c.newRequest(op, input, &CompleteMigrationOutput{})
	return CompleteMigrationRequest{Request: req, Input: input, Copy: c.CompleteMigrationRequest}
}

// CompleteMigrationRequest is the request type for the
// CompleteMigration API operation.
type CompleteMigrationRequest struct {
	*aws.Request
	Input *CompleteMigrationInput
	Copy  func(*CompleteMigrationInput) CompleteMigrationRequest
}

// Send marshals and sends the CompleteMigration API request.
func (r CompleteMigrationRequest) Send(ctx context.Context) (*CompleteMigrationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CompleteMigrationResponse{
		CompleteMigrationOutput: r.Request.Data.(*CompleteMigrationOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CompleteMigrationResponse is the response type for the
// CompleteMigration API operation.
type CompleteMigrationResponse struct {
	*CompleteMigrationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CompleteMigration request.
func (r *CompleteMigrationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
