// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeLoadBalancerPolicies.
type DescribeLoadBalancerPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The names of the policies.
	PolicyNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBalancerPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of DescribeLoadBalancerPolicies.
type DescribeLoadBalancerPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the policies.
	PolicyDescriptions []PolicyDescription `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBalancerPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLoadBalancerPolicies = "DescribeLoadBalancerPolicies"

// DescribeLoadBalancerPoliciesRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Describes the specified policies.
//
// If you specify a load balancer name, the action returns the descriptions
// of all policies created for the load balancer. If you specify a policy name
// associated with your load balancer, the action returns the description of
// that policy. If you don't specify a load balancer name, the action returns
// descriptions of the specified sample policies, or descriptions of all sample
// policies. The names of the sample policies have the ELBSample- prefix.
//
//    // Example sending a request using DescribeLoadBalancerPoliciesRequest.
//    req := client.DescribeLoadBalancerPoliciesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerPolicies
func (c *Client) DescribeLoadBalancerPoliciesRequest(input *DescribeLoadBalancerPoliciesInput) DescribeLoadBalancerPoliciesRequest {
	op := &aws.Operation{
		Name:       opDescribeLoadBalancerPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancerPoliciesInput{}
	}

	req := c.newRequest(op, input, &DescribeLoadBalancerPoliciesOutput{})
	return DescribeLoadBalancerPoliciesRequest{Request: req, Input: input, Copy: c.DescribeLoadBalancerPoliciesRequest}
}

// DescribeLoadBalancerPoliciesRequest is the request type for the
// DescribeLoadBalancerPolicies API operation.
type DescribeLoadBalancerPoliciesRequest struct {
	*aws.Request
	Input *DescribeLoadBalancerPoliciesInput
	Copy  func(*DescribeLoadBalancerPoliciesInput) DescribeLoadBalancerPoliciesRequest
}

// Send marshals and sends the DescribeLoadBalancerPolicies API request.
func (r DescribeLoadBalancerPoliciesRequest) Send(ctx context.Context) (*DescribeLoadBalancerPoliciesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLoadBalancerPoliciesResponse{
		DescribeLoadBalancerPoliciesOutput: r.Request.Data.(*DescribeLoadBalancerPoliciesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLoadBalancerPoliciesResponse is the response type for the
// DescribeLoadBalancerPolicies API operation.
type DescribeLoadBalancerPoliciesResponse struct {
	*DescribeLoadBalancerPoliciesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLoadBalancerPolicies request.
func (r *DescribeLoadBalancerPoliciesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
