// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package elasticloadbalancingv2iface provides an interface to enable mocking the Elastic Load Balancing service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package elasticloadbalancingv2iface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2"
)

// ClientAPI provides an interface to enable mocking the
// elasticloadbalancingv2.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Elastic Load Balancing v2.
//    func myFunc(svc elasticloadbalancingv2iface.ClientAPI) bool {
//        // Make svc.AddListenerCertificates request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := elasticloadbalancingv2.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        elasticloadbalancingv2iface.ClientPI
//    }
//    func (m *mockClientClient) AddListenerCertificates(input *elasticloadbalancingv2.AddListenerCertificatesInput) (*elasticloadbalancingv2.AddListenerCertificatesOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddListenerCertificatesRequest(*elasticloadbalancingv2.AddListenerCertificatesInput) elasticloadbalancingv2.AddListenerCertificatesRequest

	AddTagsRequest(*elasticloadbalancingv2.AddTagsInput) elasticloadbalancingv2.AddTagsRequest

	CreateListenerRequest(*elasticloadbalancingv2.CreateListenerInput) elasticloadbalancingv2.CreateListenerRequest

	CreateLoadBalancerRequest(*elasticloadbalancingv2.CreateLoadBalancerInput) elasticloadbalancingv2.CreateLoadBalancerRequest

	CreateRuleRequest(*elasticloadbalancingv2.CreateRuleInput) elasticloadbalancingv2.CreateRuleRequest

	CreateTargetGroupRequest(*elasticloadbalancingv2.CreateTargetGroupInput) elasticloadbalancingv2.CreateTargetGroupRequest

	DeleteListenerRequest(*elasticloadbalancingv2.DeleteListenerInput) elasticloadbalancingv2.DeleteListenerRequest

	DeleteLoadBalancerRequest(*elasticloadbalancingv2.DeleteLoadBalancerInput) elasticloadbalancingv2.DeleteLoadBalancerRequest

	DeleteRuleRequest(*elasticloadbalancingv2.DeleteRuleInput) elasticloadbalancingv2.DeleteRuleRequest

	DeleteTargetGroupRequest(*elasticloadbalancingv2.DeleteTargetGroupInput) elasticloadbalancingv2.DeleteTargetGroupRequest

	DeregisterTargetsRequest(*elasticloadbalancingv2.DeregisterTargetsInput) elasticloadbalancingv2.DeregisterTargetsRequest

	DescribeAccountLimitsRequest(*elasticloadbalancingv2.DescribeAccountLimitsInput) elasticloadbalancingv2.DescribeAccountLimitsRequest

	DescribeListenerCertificatesRequest(*elasticloadbalancingv2.DescribeListenerCertificatesInput) elasticloadbalancingv2.DescribeListenerCertificatesRequest

	DescribeListenersRequest(*elasticloadbalancingv2.DescribeListenersInput) elasticloadbalancingv2.DescribeListenersRequest

	DescribeLoadBalancerAttributesRequest(*elasticloadbalancingv2.DescribeLoadBalancerAttributesInput) elasticloadbalancingv2.DescribeLoadBalancerAttributesRequest

	DescribeLoadBalancersRequest(*elasticloadbalancingv2.DescribeLoadBalancersInput) elasticloadbalancingv2.DescribeLoadBalancersRequest

	DescribeRulesRequest(*elasticloadbalancingv2.DescribeRulesInput) elasticloadbalancingv2.DescribeRulesRequest

	DescribeSSLPoliciesRequest(*elasticloadbalancingv2.DescribeSSLPoliciesInput) elasticloadbalancingv2.DescribeSSLPoliciesRequest

	DescribeTagsRequest(*elasticloadbalancingv2.DescribeTagsInput) elasticloadbalancingv2.DescribeTagsRequest

	DescribeTargetGroupAttributesRequest(*elasticloadbalancingv2.DescribeTargetGroupAttributesInput) elasticloadbalancingv2.DescribeTargetGroupAttributesRequest

	DescribeTargetGroupsRequest(*elasticloadbalancingv2.DescribeTargetGroupsInput) elasticloadbalancingv2.DescribeTargetGroupsRequest

	DescribeTargetHealthRequest(*elasticloadbalancingv2.DescribeTargetHealthInput) elasticloadbalancingv2.DescribeTargetHealthRequest

	ModifyListenerRequest(*elasticloadbalancingv2.ModifyListenerInput) elasticloadbalancingv2.ModifyListenerRequest

	ModifyLoadBalancerAttributesRequest(*elasticloadbalancingv2.ModifyLoadBalancerAttributesInput) elasticloadbalancingv2.ModifyLoadBalancerAttributesRequest

	ModifyRuleRequest(*elasticloadbalancingv2.ModifyRuleInput) elasticloadbalancingv2.ModifyRuleRequest

	ModifyTargetGroupRequest(*elasticloadbalancingv2.ModifyTargetGroupInput) elasticloadbalancingv2.ModifyTargetGroupRequest

	ModifyTargetGroupAttributesRequest(*elasticloadbalancingv2.ModifyTargetGroupAttributesInput) elasticloadbalancingv2.ModifyTargetGroupAttributesRequest

	RegisterTargetsRequest(*elasticloadbalancingv2.RegisterTargetsInput) elasticloadbalancingv2.RegisterTargetsRequest

	RemoveListenerCertificatesRequest(*elasticloadbalancingv2.RemoveListenerCertificatesInput) elasticloadbalancingv2.RemoveListenerCertificatesRequest

	RemoveTagsRequest(*elasticloadbalancingv2.RemoveTagsInput) elasticloadbalancingv2.RemoveTagsRequest

	SetIpAddressTypeRequest(*elasticloadbalancingv2.SetIpAddressTypeInput) elasticloadbalancingv2.SetIpAddressTypeRequest

	SetRulePrioritiesRequest(*elasticloadbalancingv2.SetRulePrioritiesInput) elasticloadbalancingv2.SetRulePrioritiesRequest

	SetSecurityGroupsRequest(*elasticloadbalancingv2.SetSecurityGroupsInput) elasticloadbalancingv2.SetSecurityGroupsRequest

	SetSubnetsRequest(*elasticloadbalancingv2.SetSubnetsInput) elasticloadbalancingv2.SetSubnetsRequest

	WaitUntilLoadBalancerAvailable(context.Context, *elasticloadbalancingv2.DescribeLoadBalancersInput, ...aws.WaiterOption) error

	WaitUntilLoadBalancerExists(context.Context, *elasticloadbalancingv2.DescribeLoadBalancersInput, ...aws.WaiterOption) error

	WaitUntilLoadBalancersDeleted(context.Context, *elasticloadbalancingv2.DescribeLoadBalancersInput, ...aws.WaiterOption) error

	WaitUntilTargetDeregistered(context.Context, *elasticloadbalancingv2.DescribeTargetHealthInput, ...aws.WaiterOption) error

	WaitUntilTargetInService(context.Context, *elasticloadbalancingv2.DescribeTargetHealthInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*elasticloadbalancingv2.Client)(nil)
