// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package eventbridgeiface provides an interface to enable mocking the Amazon EventBridge service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package eventbridgeiface

import (
	"github.com/aws/aws-sdk-go-v2/service/eventbridge"
)

// ClientAPI provides an interface to enable mocking the
// eventbridge.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon EventBridge.
//    func myFunc(svc eventbridgeiface.ClientAPI) bool {
//        // Make svc.ActivateEventSource request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := eventbridge.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        eventbridgeiface.ClientPI
//    }
//    func (m *mockClientClient) ActivateEventSource(input *eventbridge.ActivateEventSourceInput) (*eventbridge.ActivateEventSourceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	ActivateEventSourceRequest(*eventbridge.ActivateEventSourceInput) eventbridge.ActivateEventSourceRequest

	CreateEventBusRequest(*eventbridge.CreateEventBusInput) eventbridge.CreateEventBusRequest

	CreatePartnerEventSourceRequest(*eventbridge.CreatePartnerEventSourceInput) eventbridge.CreatePartnerEventSourceRequest

	DeactivateEventSourceRequest(*eventbridge.DeactivateEventSourceInput) eventbridge.DeactivateEventSourceRequest

	DeleteEventBusRequest(*eventbridge.DeleteEventBusInput) eventbridge.DeleteEventBusRequest

	DeletePartnerEventSourceRequest(*eventbridge.DeletePartnerEventSourceInput) eventbridge.DeletePartnerEventSourceRequest

	DeleteRuleRequest(*eventbridge.DeleteRuleInput) eventbridge.DeleteRuleRequest

	DescribeEventBusRequest(*eventbridge.DescribeEventBusInput) eventbridge.DescribeEventBusRequest

	DescribeEventSourceRequest(*eventbridge.DescribeEventSourceInput) eventbridge.DescribeEventSourceRequest

	DescribePartnerEventSourceRequest(*eventbridge.DescribePartnerEventSourceInput) eventbridge.DescribePartnerEventSourceRequest

	DescribeRuleRequest(*eventbridge.DescribeRuleInput) eventbridge.DescribeRuleRequest

	DisableRuleRequest(*eventbridge.DisableRuleInput) eventbridge.DisableRuleRequest

	EnableRuleRequest(*eventbridge.EnableRuleInput) eventbridge.EnableRuleRequest

	ListEventBusesRequest(*eventbridge.ListEventBusesInput) eventbridge.ListEventBusesRequest

	ListEventSourcesRequest(*eventbridge.ListEventSourcesInput) eventbridge.ListEventSourcesRequest

	ListPartnerEventSourceAccountsRequest(*eventbridge.ListPartnerEventSourceAccountsInput) eventbridge.ListPartnerEventSourceAccountsRequest

	ListPartnerEventSourcesRequest(*eventbridge.ListPartnerEventSourcesInput) eventbridge.ListPartnerEventSourcesRequest

	ListRuleNamesByTargetRequest(*eventbridge.ListRuleNamesByTargetInput) eventbridge.ListRuleNamesByTargetRequest

	ListRulesRequest(*eventbridge.ListRulesInput) eventbridge.ListRulesRequest

	ListTagsForResourceRequest(*eventbridge.ListTagsForResourceInput) eventbridge.ListTagsForResourceRequest

	ListTargetsByRuleRequest(*eventbridge.ListTargetsByRuleInput) eventbridge.ListTargetsByRuleRequest

	PutEventsRequest(*eventbridge.PutEventsInput) eventbridge.PutEventsRequest

	PutPartnerEventsRequest(*eventbridge.PutPartnerEventsInput) eventbridge.PutPartnerEventsRequest

	PutPermissionRequest(*eventbridge.PutPermissionInput) eventbridge.PutPermissionRequest

	PutRuleRequest(*eventbridge.PutRuleInput) eventbridge.PutRuleRequest

	PutTargetsRequest(*eventbridge.PutTargetsInput) eventbridge.PutTargetsRequest

	RemovePermissionRequest(*eventbridge.RemovePermissionInput) eventbridge.RemovePermissionRequest

	RemoveTargetsRequest(*eventbridge.RemoveTargetsInput) eventbridge.RemoveTargetsRequest

	TagResourceRequest(*eventbridge.TagResourceInput) eventbridge.TagResourceRequest

	TestEventPatternRequest(*eventbridge.TestEventPatternInput) eventbridge.TestEventPatternRequest

	UntagResourceRequest(*eventbridge.UntagResourceInput) eventbridge.UntagResourceRequest
}

var _ ClientAPI = (*eventbridge.Client)(nil)
