// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetWorkflowInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include a graph when returning the workflow resource
	// metadata.
	IncludeGraph *bool `type:"boolean"`

	// The name of the workflow to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetWorkflowInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The resource metadata for the workflow.
	Workflow *Workflow `type:"structure"`
}

// String returns the string representation
func (s GetWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetWorkflow = "GetWorkflow"

// GetWorkflowRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves resource metadata for a workflow.
//
//    // Example sending a request using GetWorkflowRequest.
//    req := client.GetWorkflowRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow
func (c *Client) GetWorkflowRequest(input *GetWorkflowInput) GetWorkflowRequest {
	op := &aws.Operation{
		Name:       opGetWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWorkflowInput{}
	}

	req := c.newRequest(op, input, &GetWorkflowOutput{})
	return GetWorkflowRequest{Request: req, Input: input, Copy: c.GetWorkflowRequest}
}

// GetWorkflowRequest is the request type for the
// GetWorkflow API operation.
type GetWorkflowRequest struct {
	*aws.Request
	Input *GetWorkflowInput
	Copy  func(*GetWorkflowInput) GetWorkflowRequest
}

// Send marshals and sends the GetWorkflow API request.
func (r GetWorkflowRequest) Send(ctx context.Context) (*GetWorkflowResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetWorkflowResponse{
		GetWorkflowOutput: r.Request.Data.(*GetWorkflowOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetWorkflowResponse is the response type for the
// GetWorkflow API operation.
type GetWorkflowResponse struct {
	*GetWorkflowOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetWorkflow request.
func (r *GetWorkflowResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
