// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListConnectorDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListConnectorDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConnectorDefinitionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListConnectorDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConnectorDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConnectorDefinitionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Definitions != nil {
		v := s.Definitions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Definitions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListConnectorDefinitions = "ListConnectorDefinitions"

// ListConnectorDefinitionsRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Retrieves a list of connector definitions.
//
//    // Example sending a request using ListConnectorDefinitionsRequest.
//    req := client.ListConnectorDefinitionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions
func (c *Client) ListConnectorDefinitionsRequest(input *ListConnectorDefinitionsInput) ListConnectorDefinitionsRequest {
	op := &aws.Operation{
		Name:       opListConnectorDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/connectors",
	}

	if input == nil {
		input = &ListConnectorDefinitionsInput{}
	}

	req := c.newRequest(op, input, &ListConnectorDefinitionsOutput{})
	return ListConnectorDefinitionsRequest{Request: req, Input: input, Copy: c.ListConnectorDefinitionsRequest}
}

// ListConnectorDefinitionsRequest is the request type for the
// ListConnectorDefinitions API operation.
type ListConnectorDefinitionsRequest struct {
	*aws.Request
	Input *ListConnectorDefinitionsInput
	Copy  func(*ListConnectorDefinitionsInput) ListConnectorDefinitionsRequest
}

// Send marshals and sends the ListConnectorDefinitions API request.
func (r ListConnectorDefinitionsRequest) Send(ctx context.Context) (*ListConnectorDefinitionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListConnectorDefinitionsResponse{
		ListConnectorDefinitionsOutput: r.Request.Data.(*ListConnectorDefinitionsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListConnectorDefinitionsResponse is the response type for the
// ListConnectorDefinitions API operation.
type ListConnectorDefinitionsResponse struct {
	*ListConnectorDefinitionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListConnectorDefinitions request.
func (r *ListConnectorDefinitionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
