// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type UntagRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the IAM role from which you want to remove tags.
	//
	// This parameter accepts (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that consist of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`

	// A list of key names as a simple array of strings. The tags with matching
	// keys are removed from the specified role.
	//
	// TagKeys is a required field
	TagKeys []string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagRoleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagRoleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UntagRoleInput"}

	if s.RoleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleName", 1))
	}

	if s.TagKeys == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UntagRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagRoleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUntagRole = "UntagRole"

// UntagRoleRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Removes the specified tags from the role. For more information about tagging,
// see Tagging IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
// in the IAM User Guide.
//
//    // Example sending a request using UntagRoleRequest.
//    req := client.UntagRoleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagRole
func (c *Client) UntagRoleRequest(input *UntagRoleInput) UntagRoleRequest {
	op := &aws.Operation{
		Name:       opUntagRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagRoleInput{}
	}

	req := c.newRequest(op, input, &UntagRoleOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UntagRoleRequest{Request: req, Input: input, Copy: c.UntagRoleRequest}
}

// UntagRoleRequest is the request type for the
// UntagRole API operation.
type UntagRoleRequest struct {
	*aws.Request
	Input *UntagRoleInput
	Copy  func(*UntagRoleInput) UntagRoleRequest
}

// Send marshals and sends the UntagRole API request.
func (r UntagRoleRequest) Send(ctx context.Context) (*UntagRoleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UntagRoleResponse{
		UntagRoleOutput: r.Request.Data.(*UntagRoleOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UntagRoleResponse is the response type for the
// UntagRole API operation.
type UntagRoleResponse struct {
	*UntagRoleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UntagRole request.
func (r *UntagRoleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
