// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutComponentPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component that this policy should be
	// applied to.
	//
	// ComponentArn is a required field
	ComponentArn *string `locationName:"componentArn" type:"string" required:"true"`

	// The policy to apply.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutComponentPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutComponentPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutComponentPolicyInput"}

	if s.ComponentArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentArn"))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutComponentPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ComponentArn != nil {
		v := *s.ComponentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "componentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutComponentPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component that this policy was applied
	// to.
	ComponentArn *string `locationName:"componentArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s PutComponentPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutComponentPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComponentArn != nil {
		v := *s.ComponentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "componentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opPutComponentPolicy = "PutComponentPolicy"

// PutComponentPolicyRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Applies a policy to a component.
//
//    // Example sending a request using PutComponentPolicyRequest.
//    req := client.PutComponentPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy
func (c *Client) PutComponentPolicyRequest(input *PutComponentPolicyInput) PutComponentPolicyRequest {
	op := &aws.Operation{
		Name:       opPutComponentPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/PutComponentPolicy",
	}

	if input == nil {
		input = &PutComponentPolicyInput{}
	}

	req := c.newRequest(op, input, &PutComponentPolicyOutput{})
	return PutComponentPolicyRequest{Request: req, Input: input, Copy: c.PutComponentPolicyRequest}
}

// PutComponentPolicyRequest is the request type for the
// PutComponentPolicy API operation.
type PutComponentPolicyRequest struct {
	*aws.Request
	Input *PutComponentPolicyInput
	Copy  func(*PutComponentPolicyInput) PutComponentPolicyRequest
}

// Send marshals and sends the PutComponentPolicy API request.
func (r PutComponentPolicyRequest) Send(ctx context.Context) (*PutComponentPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutComponentPolicyResponse{
		PutComponentPolicyOutput: r.Request.Data.(*PutComponentPolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutComponentPolicyResponse is the response type for the
// PutComponentPolicy API operation.
type PutComponentPolicyResponse struct {
	*PutComponentPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutComponentPolicy request.
func (r *PutComponentPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
