// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for the GetLoggingOptions operation.
type GetLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetLoggingOptionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

// The output from the GetLoggingOptions operation.
type GetLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The logging level.
	LogLevel LogLevel `locationName:"logLevel" type:"string" enum:"true"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s GetLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetLoggingOptionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LogLevel) > 0 {
		v := s.LogLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetLoggingOptions = "GetLoggingOptions"

// GetLoggingOptionsRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets the logging options.
//
// NOTE: use of this command is not recommended. Use GetV2LoggingOptions instead.
//
//    // Example sending a request using GetLoggingOptionsRequest.
//    req := client.GetLoggingOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetLoggingOptionsRequest(input *GetLoggingOptionsInput) GetLoggingOptionsRequest {
	op := &aws.Operation{
		Name:       opGetLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &GetLoggingOptionsInput{}
	}

	req := c.newRequest(op, input, &GetLoggingOptionsOutput{})
	return GetLoggingOptionsRequest{Request: req, Input: input, Copy: c.GetLoggingOptionsRequest}
}

// GetLoggingOptionsRequest is the request type for the
// GetLoggingOptions API operation.
type GetLoggingOptionsRequest struct {
	*aws.Request
	Input *GetLoggingOptionsInput
	Copy  func(*GetLoggingOptionsInput) GetLoggingOptionsRequest
}

// Send marshals and sends the GetLoggingOptions API request.
func (r GetLoggingOptionsRequest) Send(ctx context.Context) (*GetLoggingOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLoggingOptionsResponse{
		GetLoggingOptionsOutput: r.Request.Data.(*GetLoggingOptionsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetLoggingOptionsResponse is the response type for the
// GetLoggingOptions API operation.
type GetLoggingOptionsResponse struct {
	*GetLoggingOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLoggingOptions request.
func (r *GetLoggingOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
