// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeInputInput struct {
	_ struct{} `type:"structure"`

	// The name of the input.
	//
	// InputName is a required field
	InputName *string `location:"uri" locationName:"inputName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeInputInput"}

	if s.InputName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeInputInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.InputName != nil {
		v := *s.InputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "inputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeInputOutput struct {
	_ struct{} `type:"structure"`

	// Information about the input.
	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation
func (s DescribeInputOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeInputOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Input != nil {
		v := s.Input

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "input", v, metadata)
	}
	return nil
}

const opDescribeInput = "DescribeInput"

// DescribeInputRequest returns a request value for making API operation for
// AWS IoT Events.
//
// Describes an input.
//
//    // Example sending a request using DescribeInputRequest.
//    req := client.DescribeInputRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput
func (c *Client) DescribeInputRequest(input *DescribeInputInput) DescribeInputRequest {
	op := &aws.Operation{
		Name:       opDescribeInput,
		HTTPMethod: "GET",
		HTTPPath:   "/inputs/{inputName}",
	}

	if input == nil {
		input = &DescribeInputInput{}
	}

	req := c.newRequest(op, input, &DescribeInputOutput{})
	return DescribeInputRequest{Request: req, Input: input, Copy: c.DescribeInputRequest}
}

// DescribeInputRequest is the request type for the
// DescribeInput API operation.
type DescribeInputRequest struct {
	*aws.Request
	Input *DescribeInputInput
	Copy  func(*DescribeInputInput) DescribeInputRequest
}

// Send marshals and sends the DescribeInput API request.
func (r DescribeInputRequest) Send(ctx context.Context) (*DescribeInputResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInputResponse{
		DescribeInputOutput: r.Request.Data.(*DescribeInputOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeInputResponse is the response type for the
// DescribeInput API operation.
type DescribeInputResponse struct {
	*DescribeInputOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInput request.
func (r *DescribeInputResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
