// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotevents

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An action to be performed when the "condition" is TRUE.
type Action struct {
	_ struct{} `type:"structure"`

	// Information needed to clear the timer.
	ClearTimer *ClearTimerAction `locationName:"clearTimer" type:"structure"`

	// Sends information about the detector model instance and the event which triggered
	// the action to a Kinesis Data Firehose delivery stream.
	Firehose *FirehoseAction `locationName:"firehose" type:"structure"`

	// Sends an IoT Events input, passing in information about the detector model
	// instance and the event which triggered the action.
	IotEvents *IotEventsAction `locationName:"iotEvents" type:"structure"`

	// Publishes an MQTT message with the given topic to the AWS IoT message broker.
	IotTopicPublish *IotTopicPublishAction `locationName:"iotTopicPublish" type:"structure"`

	// Calls an AWS Lambda function, passing in information about the detector model
	// instance and the event which triggered the action.
	Lambda *LambdaAction `locationName:"lambda" type:"structure"`

	// Information needed to reset the timer.
	ResetTimer *ResetTimerAction `locationName:"resetTimer" type:"structure"`

	// Information needed to set the timer.
	SetTimer *SetTimerAction `locationName:"setTimer" type:"structure"`

	// Sets a variable to a specified value.
	SetVariable *SetVariableAction `locationName:"setVariable" type:"structure"`

	// Sends an Amazon SNS message.
	Sns *SNSTopicPublishAction `locationName:"sns" type:"structure"`

	// Sends information about the detector model instance and the event which triggered
	// the action to an Amazon SQS queue.
	Sqs *SqsAction `locationName:"sqs" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Action"}
	if s.ClearTimer != nil {
		if err := s.ClearTimer.Validate(); err != nil {
			invalidParams.AddNested("ClearTimer", err.(aws.ErrInvalidParams))
		}
	}
	if s.Firehose != nil {
		if err := s.Firehose.Validate(); err != nil {
			invalidParams.AddNested("Firehose", err.(aws.ErrInvalidParams))
		}
	}
	if s.IotEvents != nil {
		if err := s.IotEvents.Validate(); err != nil {
			invalidParams.AddNested("IotEvents", err.(aws.ErrInvalidParams))
		}
	}
	if s.IotTopicPublish != nil {
		if err := s.IotTopicPublish.Validate(); err != nil {
			invalidParams.AddNested("IotTopicPublish", err.(aws.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResetTimer != nil {
		if err := s.ResetTimer.Validate(); err != nil {
			invalidParams.AddNested("ResetTimer", err.(aws.ErrInvalidParams))
		}
	}
	if s.SetTimer != nil {
		if err := s.SetTimer.Validate(); err != nil {
			invalidParams.AddNested("SetTimer", err.(aws.ErrInvalidParams))
		}
	}
	if s.SetVariable != nil {
		if err := s.SetVariable.Validate(); err != nil {
			invalidParams.AddNested("SetVariable", err.(aws.ErrInvalidParams))
		}
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(aws.ErrInvalidParams))
		}
	}
	if s.Sqs != nil {
		if err := s.Sqs.Validate(); err != nil {
			invalidParams.AddNested("Sqs", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Action) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClearTimer != nil {
		v := s.ClearTimer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "clearTimer", v, metadata)
	}
	if s.Firehose != nil {
		v := s.Firehose

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "firehose", v, metadata)
	}
	if s.IotEvents != nil {
		v := s.IotEvents

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iotEvents", v, metadata)
	}
	if s.IotTopicPublish != nil {
		v := s.IotTopicPublish

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iotTopicPublish", v, metadata)
	}
	if s.Lambda != nil {
		v := s.Lambda

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "lambda", v, metadata)
	}
	if s.ResetTimer != nil {
		v := s.ResetTimer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resetTimer", v, metadata)
	}
	if s.SetTimer != nil {
		v := s.SetTimer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "setTimer", v, metadata)
	}
	if s.SetVariable != nil {
		v := s.SetVariable

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "setVariable", v, metadata)
	}
	if s.Sns != nil {
		v := s.Sns

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sns", v, metadata)
	}
	if s.Sqs != nil {
		v := s.Sqs

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sqs", v, metadata)
	}
	return nil
}

// The attributes from the JSON payload that are made available by the input.
// Inputs are derived from messages sent to the AWS IoT Events system using
// BatchPutMessage. Each such message contains a JSON payload, and those attributes
// (and their paired values) specified here are available for use in the condition
// expressions used by detectors.
type Attribute struct {
	_ struct{} `type:"structure"`

	// An expression that specifies an attribute-value pair in a JSON structure.
	// Use this to specify an attribute from the JSON payload that is made available
	// by the input. Inputs are derived from messages sent to the AWS IoT Events
	// system (BatchPutMessage). Each such message contains a JSON payload, and
	// the attribute (and its paired value) specified here are available for use
	// in the "condition" expressions used by detectors.
	//
	// Syntax: <field-name>.<field-name>...
	//
	// JsonPath is a required field
	JsonPath *string `locationName:"jsonPath" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Attribute"}

	if s.JsonPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("JsonPath"))
	}
	if s.JsonPath != nil && len(*s.JsonPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JsonPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Attribute) MarshalFields(e protocol.FieldEncoder) error {
	if s.JsonPath != nil {
		v := *s.JsonPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jsonPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information needed to clear the timer.
type ClearTimerAction struct {
	_ struct{} `type:"structure"`

	// The name of the timer to clear.
	//
	// TimerName is a required field
	TimerName *string `locationName:"timerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ClearTimerAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClearTimerAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ClearTimerAction"}

	if s.TimerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimerName"))
	}
	if s.TimerName != nil && len(*s.TimerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TimerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ClearTimerAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.TimerName != nil {
		v := *s.TimerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The detector model and the specific detectors (instances) for which the logging
// level is given.
type DetectorDebugOption struct {
	_ struct{} `type:"structure"`

	// The name of the detector model.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The value of the input attribute key used to create the detector (the instance
	// of the detector model).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`
}

// String returns the string representation
func (s DetectorDebugOption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectorDebugOption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectorDebugOption"}

	if s.DetectorModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorDebugOption) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyValue != nil {
		v := *s.KeyValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the detector model.
type DetectorModel struct {
	_ struct{} `type:"structure"`

	// Information about how the detector is configured.
	DetectorModelConfiguration *DetectorModelConfiguration `locationName:"detectorModelConfiguration" type:"structure"`

	// Information that defines how a detector operates.
	DetectorModelDefinition *DetectorModelDefinition `locationName:"detectorModelDefinition" type:"structure"`
}

// String returns the string representation
func (s DetectorModel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorModel) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetectorModelConfiguration != nil {
		v := s.DetectorModelConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "detectorModelConfiguration", v, metadata)
	}
	if s.DetectorModelDefinition != nil {
		v := s.DetectorModelDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "detectorModelDefinition", v, metadata)
	}
	return nil
}

// Information about how the detector model is configured.
type DetectorModelConfiguration struct {
	_ struct{} `type:"structure"`

	// The time the detector model was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ARN of the detector model.
	DetectorModelArn *string `locationName:"detectorModelArn" type:"string"`

	// A brief description of the detector model.
	DetectorModelDescription *string `locationName:"detectorModelDescription" type:"string"`

	// The name of the detector model.
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model.
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// When set to SERIAL, variables are updated and event conditions evaluated
	// in the order that the events are defined. When set to BATCH, variables are
	// updated and events performed only after all event conditions are evaluated.
	EvaluationMethod EvaluationMethod `locationName:"evaluationMethod" type:"string" enum:"true"`

	// The input attribute key used to identify a device or system to create a detector
	// (an instance of the detector model) and then to route each input received
	// to the appropriate detector (instance). This parameter uses a JSON-path expression
	// to specify the attribute-value pair in the message payload of each input
	// that is used to identify the device associated with the input.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The time the detector model was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The ARN of the role that grants permission to AWS IoT Events to perform its
	// operations.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The status of the detector model.
	Status DetectorModelVersionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DetectorModelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorModelConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DetectorModelArn != nil {
		v := *s.DetectorModelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelDescription != nil {
		v := *s.DetectorModelDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelVersion != nil {
		v := *s.DetectorModelVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EvaluationMethod) > 0 {
		v := s.EvaluationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "evaluationMethod", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information that defines how a detector operates.
type DetectorModelDefinition struct {
	_ struct{} `type:"structure"`

	// The state that is entered at the creation of each detector (instance).
	//
	// InitialStateName is a required field
	InitialStateName *string `locationName:"initialStateName" min:"1" type:"string" required:"true"`

	// Information about the states of the detector.
	//
	// States is a required field
	States []State `locationName:"states" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorModelDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectorModelDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectorModelDefinition"}

	if s.InitialStateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InitialStateName"))
	}
	if s.InitialStateName != nil && len(*s.InitialStateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InitialStateName", 1))
	}

	if s.States == nil {
		invalidParams.Add(aws.NewErrParamRequired("States"))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("States", 1))
	}
	if s.States != nil {
		for i, v := range s.States {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "States", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorModelDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.InitialStateName != nil {
		v := *s.InitialStateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "initialStateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.States != nil {
		v := s.States

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "states", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about the detector model.
type DetectorModelSummary struct {
	_ struct{} `type:"structure"`

	// The time the detector model was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// A brief description of the detector model.
	DetectorModelDescription *string `locationName:"detectorModelDescription" type:"string"`

	// The name of the detector model.
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`
}

// String returns the string representation
func (s DetectorModelSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorModelSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DetectorModelDescription != nil {
		v := *s.DetectorModelDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the detector model version.
type DetectorModelVersionSummary struct {
	_ struct{} `type:"structure"`

	// The time the detector model version was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ARN of the detector model version.
	DetectorModelArn *string `locationName:"detectorModelArn" type:"string"`

	// The name of the detector model.
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The ID of the detector model version.
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// When set to SERIAL, variables are updated and event conditions evaluated
	// in the order that the events are defined. When set to BATCH, variables are
	// updated and events performed only after all event conditions are evaluated.
	EvaluationMethod EvaluationMethod `locationName:"evaluationMethod" type:"string" enum:"true"`

	// The last time the detector model version was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The ARN of the role that grants the detector model permission to perform
	// its tasks.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The status of the detector model version.
	Status DetectorModelVersionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DetectorModelVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorModelVersionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DetectorModelArn != nil {
		v := *s.DetectorModelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelVersion != nil {
		v := *s.DetectorModelVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EvaluationMethod) > 0 {
		v := s.EvaluationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "evaluationMethod", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the "actions" to be performed when the "condition" evaluates to
// TRUE.
type Event struct {
	_ struct{} `type:"structure"`

	// The actions to be performed.
	Actions []Action `locationName:"actions" type:"list"`

	// [Optional] The Boolean expression that when TRUE causes the "actions" to
	// be performed. If not present, the actions are performed (=TRUE); if the expression
	// result is not a Boolean value, the actions are NOT performed (=FALSE).
	Condition *string `locationName:"condition" type:"string"`

	// The name of the event.
	//
	// EventName is a required field
	EventName *string `locationName:"eventName" type:"string" required:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Event) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Event"}

	if s.EventName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventName"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Event) MarshalFields(e protocol.FieldEncoder) error {
	if s.Actions != nil {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Condition != nil {
		v := *s.Condition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "condition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventName != nil {
		v := *s.EventName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Sends information about the detector model instance and the event which triggered
// the action to a Kinesis Data Firehose delivery stream.
type FirehoseAction struct {
	_ struct{} `type:"structure"`

	// The name of the Kinesis Data Firehose delivery stream where the data is written.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `locationName:"deliveryStreamName" type:"string" required:"true"`

	// A character separator that is used to separate records written to the Kinesis
	// Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab),
	// '\r\n' (Windows newline), ',' (comma).
	Separator *string `locationName:"separator" type:"string"`
}

// String returns the string representation
func (s FirehoseAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FirehoseAction"}

	if s.DeliveryStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FirehoseAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeliveryStreamName != nil {
		v := *s.DeliveryStreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deliveryStreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Separator != nil {
		v := *s.Separator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "separator", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the input.
type Input struct {
	_ struct{} `type:"structure"`

	// Information about the configuration of an input.
	InputConfiguration *InputConfiguration `locationName:"inputConfiguration" type:"structure"`

	// The definition of the input.
	InputDefinition *InputDefinition `locationName:"inputDefinition" type:"structure"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Input) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputConfiguration != nil {
		v := s.InputConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputConfiguration", v, metadata)
	}
	if s.InputDefinition != nil {
		v := s.InputDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputDefinition", v, metadata)
	}
	return nil
}

// Information about the configuration of an input.
type InputConfiguration struct {
	_ struct{} `type:"structure"`

	// The time the input was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The ARN of the input.
	//
	// InputArn is a required field
	InputArn *string `locationName:"inputArn" type:"string" required:"true"`

	// A brief description of the input.
	InputDescription *string `locationName:"inputDescription" type:"string"`

	// The name of the input.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// The last time the input was updated.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The status of the input.
	//
	// Status is a required field
	Status InputStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.InputArn != nil {
		v := *s.InputArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputDescription != nil {
		v := *s.InputDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputName != nil {
		v := *s.InputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The definition of the input.
type InputDefinition struct {
	_ struct{} `type:"structure"`

	// The attributes from the JSON payload that are made available by the input.
	// Inputs are derived from messages sent to the AWS IoT Events system using
	// BatchPutMessage. Each such message contains a JSON payload, and those attributes
	// (and their paired values) specified here are available for use in the "condition"
	// expressions used by detectors that monitor this input.
	//
	// Attributes is a required field
	Attributes []Attribute `locationName:"attributes" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InputDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputDefinition"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attributes", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about the input.
type InputSummary struct {
	_ struct{} `type:"structure"`

	// The time the input was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ARN of the input.
	InputArn *string `locationName:"inputArn" type:"string"`

	// A brief description of the input.
	InputDescription *string `locationName:"inputDescription" type:"string"`

	// The name of the input.
	InputName *string `locationName:"inputName" min:"1" type:"string"`

	// The last time the input was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the input.
	Status InputStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s InputSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.InputArn != nil {
		v := *s.InputArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputDescription != nil {
		v := *s.InputDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputName != nil {
		v := *s.InputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Sends an IoT Events input, passing in information about the detector model
// instance and the event which triggered the action.
type IotEventsAction struct {
	_ struct{} `type:"structure"`

	// The name of the AWS IoT Events input where the data is sent.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IotEventsAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IotEventsAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IotEventsAction"}

	if s.InputName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IotEventsAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputName != nil {
		v := *s.InputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information required to publish the MQTT message via the AWS IoT message
// broker.
type IotTopicPublishAction struct {
	_ struct{} `type:"structure"`

	// The MQTT topic of the message.
	//
	// MqttTopic is a required field
	MqttTopic *string `locationName:"mqttTopic" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IotTopicPublishAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IotTopicPublishAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IotTopicPublishAction"}

	if s.MqttTopic == nil {
		invalidParams.Add(aws.NewErrParamRequired("MqttTopic"))
	}
	if s.MqttTopic != nil && len(*s.MqttTopic) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MqttTopic", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IotTopicPublishAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.MqttTopic != nil {
		v := *s.MqttTopic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mqttTopic", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Calls an AWS Lambda function, passing in information about the detector model
// instance and the event which triggered the action.
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda function which is executed.
	//
	// FunctionArn is a required field
	FunctionArn *string `locationName:"functionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaAction"}

	if s.FunctionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionArn"))
	}
	if s.FunctionArn != nil && len(*s.FunctionArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "functionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The values of the AWS IoT Events logging options.
type LoggingOptions struct {
	_ struct{} `type:"structure"`

	// Information that identifies those detector models and their detectors (instances)
	// for which the logging level is given.
	DetectorDebugOptions []DetectorDebugOption `locationName:"detectorDebugOptions" min:"1" type:"list"`

	// If TRUE, logging is enabled for AWS IoT Events.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The logging level.
	//
	// Level is a required field
	Level LoggingLevel `locationName:"level" type:"string" required:"true" enum:"true"`

	// The ARN of the role that grants permission to AWS IoT Events to perform logging.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingOptions"}
	if s.DetectorDebugOptions != nil && len(s.DetectorDebugOptions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorDebugOptions", 1))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}
	if len(s.Level) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Level"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DetectorDebugOptions != nil {
		for i, v := range s.DetectorDebugOptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DetectorDebugOptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetectorDebugOptions != nil {
		v := s.DetectorDebugOptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "detectorDebugOptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	if len(s.Level) > 0 {
		v := s.Level

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "level", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// When entering this state, perform these actions if the condition is TRUE.
type OnEnterLifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the actions that are performed when the state is entered and the
	// "condition" is TRUE.
	Events []Event `locationName:"events" type:"list"`
}

// String returns the string representation
func (s OnEnterLifecycle) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnEnterLifecycle) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OnEnterLifecycle"}
	if s.Events != nil {
		for i, v := range s.Events {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OnEnterLifecycle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "events", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// When exiting this state, perform these "actions" if the specified "condition"
// is TRUE.
type OnExitLifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the "actions" that are performed when the state is exited and the
	// "condition" is TRUE.
	Events []Event `locationName:"events" type:"list"`
}

// String returns the string representation
func (s OnExitLifecycle) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnExitLifecycle) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OnExitLifecycle"}
	if s.Events != nil {
		for i, v := range s.Events {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OnExitLifecycle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "events", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the actions performed when the "condition" evaluates to TRUE.
type OnInputLifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the actions performed when the "condition" evaluates to TRUE.
	Events []Event `locationName:"events" type:"list"`

	// Specifies the actions performed, and the next state entered, when a "condition"
	// evaluates to TRUE.
	TransitionEvents []TransitionEvent `locationName:"transitionEvents" type:"list"`
}

// String returns the string representation
func (s OnInputLifecycle) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnInputLifecycle) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OnInputLifecycle"}
	if s.Events != nil {
		for i, v := range s.Events {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TransitionEvents != nil {
		for i, v := range s.TransitionEvents {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TransitionEvents", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OnInputLifecycle) MarshalFields(e protocol.FieldEncoder) error {
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "events", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TransitionEvents != nil {
		v := s.TransitionEvents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "transitionEvents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information needed to reset the timer.
type ResetTimerAction struct {
	_ struct{} `type:"structure"`

	// The name of the timer to reset.
	//
	// TimerName is a required field
	TimerName *string `locationName:"timerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetTimerAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetTimerAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResetTimerAction"}

	if s.TimerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimerName"))
	}
	if s.TimerName != nil && len(*s.TimerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TimerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResetTimerAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.TimerName != nil {
		v := *s.TimerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information required to publish the Amazon SNS message.
type SNSTopicPublishAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon SNS target where the message is sent.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SNSTopicPublishAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSTopicPublishAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SNSTopicPublishAction"}

	if s.TargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SNSTopicPublishAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetArn != nil {
		v := *s.TargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information needed to set the timer.
type SetTimerAction struct {
	_ struct{} `type:"structure"`

	// The number of seconds until the timer expires. The minimum value is 60 seconds
	// to ensure accuracy.
	//
	// Seconds is a required field
	Seconds *int64 `locationName:"seconds" type:"integer" required:"true"`

	// The name of the timer.
	//
	// TimerName is a required field
	TimerName *string `locationName:"timerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetTimerAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTimerAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetTimerAction"}

	if s.Seconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("Seconds"))
	}

	if s.TimerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimerName"))
	}
	if s.TimerName != nil && len(*s.TimerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TimerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetTimerAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Seconds != nil {
		v := *s.Seconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "seconds", protocol.Int64Value(v), metadata)
	}
	if s.TimerName != nil {
		v := *s.TimerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the variable and its new value.
type SetVariableAction struct {
	_ struct{} `type:"structure"`

	// The new value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`

	// The name of the variable.
	//
	// VariableName is a required field
	VariableName *string `locationName:"variableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetVariableAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVariableAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetVariableAction"}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if s.VariableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VariableName"))
	}
	if s.VariableName != nil && len(*s.VariableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VariableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetVariableAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VariableName != nil {
		v := *s.VariableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "variableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Sends information about the detector model instance and the event which triggered
// the action to an Amazon SQS queue.
type SqsAction struct {
	_ struct{} `type:"structure"`

	// The URL of the Amazon SQS queue where the data is written.
	//
	// QueueUrl is a required field
	QueueUrl *string `locationName:"queueUrl" type:"string" required:"true"`

	// Set this to TRUE if you want the data to be Base-64 encoded before it is
	// written to the queue. Otherwise, set this to FALSE.
	UseBase64 *bool `locationName:"useBase64" type:"boolean"`
}

// String returns the string representation
func (s SqsAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqsAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqsAction"}

	if s.QueueUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SqsAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.QueueUrl != nil {
		v := *s.QueueUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queueUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UseBase64 != nil {
		v := *s.UseBase64

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "useBase64", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information that defines a state of a detector.
type State struct {
	_ struct{} `type:"structure"`

	// When entering this state, perform these "actions" if the "condition" is TRUE.
	OnEnter *OnEnterLifecycle `locationName:"onEnter" type:"structure"`

	// When exiting this state, perform these "actions" if the specified "condition"
	// is TRUE.
	OnExit *OnExitLifecycle `locationName:"onExit" type:"structure"`

	// When an input is received and the "condition" is TRUE, perform the specified
	// "actions".
	OnInput *OnInputLifecycle `locationName:"onInput" type:"structure"`

	// The name of the state.
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s State) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *State) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "State"}

	if s.StateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateName"))
	}
	if s.StateName != nil && len(*s.StateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StateName", 1))
	}
	if s.OnEnter != nil {
		if err := s.OnEnter.Validate(); err != nil {
			invalidParams.AddNested("OnEnter", err.(aws.ErrInvalidParams))
		}
	}
	if s.OnExit != nil {
		if err := s.OnExit.Validate(); err != nil {
			invalidParams.AddNested("OnExit", err.(aws.ErrInvalidParams))
		}
	}
	if s.OnInput != nil {
		if err := s.OnInput.Validate(); err != nil {
			invalidParams.AddNested("OnInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s State) MarshalFields(e protocol.FieldEncoder) error {
	if s.OnEnter != nil {
		v := s.OnEnter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "onEnter", v, metadata)
	}
	if s.OnExit != nil {
		v := s.OnExit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "onExit", v, metadata)
	}
	if s.OnInput != nil {
		v := s.OnInput

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "onInput", v, metadata)
	}
	if s.StateName != nil {
		v := *s.StateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Metadata that can be used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the actions performed and the next state entered when a "condition"
// evaluates to TRUE.
type TransitionEvent struct {
	_ struct{} `type:"structure"`

	// The actions to be performed.
	Actions []Action `locationName:"actions" type:"list"`

	// [Required] A Boolean expression that when TRUE causes the actions to be performed
	// and the "nextState" to be entered.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`

	// The name of the transition event.
	//
	// EventName is a required field
	EventName *string `locationName:"eventName" type:"string" required:"true"`

	// The next state to enter.
	//
	// NextState is a required field
	NextState *string `locationName:"nextState" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TransitionEvent) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransitionEvent) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransitionEvent"}

	if s.Condition == nil {
		invalidParams.Add(aws.NewErrParamRequired("Condition"))
	}

	if s.EventName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventName"))
	}

	if s.NextState == nil {
		invalidParams.Add(aws.NewErrParamRequired("NextState"))
	}
	if s.NextState != nil && len(*s.NextState) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextState", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TransitionEvent) MarshalFields(e protocol.FieldEncoder) error {
	if s.Actions != nil {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Condition != nil {
		v := *s.Condition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "condition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventName != nil {
		v := *s.EventName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextState != nil {
		v := *s.NextState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextState", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
