// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsecuretunneling

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type OpenTunnelInput struct {
	_ struct{} `type:"structure"`

	// A short text description of the tunnel.
	Description *string `locationName:"description" type:"string"`

	// The destination configuration for the OpenTunnel request.
	DestinationConfig *DestinationConfig `locationName:"destinationConfig" type:"structure"`

	// A collection of tag metadata.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// Timeout configuration for a tunnel.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`
}

// String returns the string representation
func (s OpenTunnelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenTunnelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OpenTunnelInput"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.DestinationConfig != nil {
		if err := s.DestinationConfig.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TimeoutConfig != nil {
		if err := s.TimeoutConfig.Validate(); err != nil {
			invalidParams.AddNested("TimeoutConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type OpenTunnelOutput struct {
	_ struct{} `type:"structure"`

	// The access token the destination local proxy uses to connect to AWS IoT Secure
	// Tunneling.
	DestinationAccessToken *string `locationName:"destinationAccessToken" type:"string" sensitive:"true"`

	// The access token the source local proxy uses to connect to AWS IoT Secure
	// Tunneling.
	SourceAccessToken *string `locationName:"sourceAccessToken" type:"string" sensitive:"true"`

	// The Amazon Resource Name for the tunnel. The tunnel ARN format is arn:aws:tunnel:<region>:<account-id>:tunnel/<tunnel-id>
	TunnelArn *string `locationName:"tunnelArn" min:"1" type:"string"`

	// A unique alpha-numeric tunnel ID.
	TunnelId *string `locationName:"tunnelId" type:"string"`
}

// String returns the string representation
func (s OpenTunnelOutput) String() string {
	return awsutil.Prettify(s)
}

const opOpenTunnel = "OpenTunnel"

// OpenTunnelRequest returns a request value for making API operation for
// AWS IoT Secure Tunneling.
//
// Creates a new tunnel, and returns two client access tokens for clients to
// use to connect to the AWS IoT Secure Tunneling proxy server. .
//
//    // Example sending a request using OpenTunnelRequest.
//    req := client.OpenTunnelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/OpenTunnel
func (c *Client) OpenTunnelRequest(input *OpenTunnelInput) OpenTunnelRequest {
	op := &aws.Operation{
		Name:       opOpenTunnel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OpenTunnelInput{}
	}

	req := c.newRequest(op, input, &OpenTunnelOutput{})
	return OpenTunnelRequest{Request: req, Input: input, Copy: c.OpenTunnelRequest}
}

// OpenTunnelRequest is the request type for the
// OpenTunnel API operation.
type OpenTunnelRequest struct {
	*aws.Request
	Input *OpenTunnelInput
	Copy  func(*OpenTunnelInput) OpenTunnelRequest
}

// Send marshals and sends the OpenTunnel API request.
func (r OpenTunnelRequest) Send(ctx context.Context) (*OpenTunnelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &OpenTunnelResponse{
		OpenTunnelOutput: r.Request.Data.(*OpenTunnelOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// OpenTunnelResponse is the response type for the
// OpenTunnel API operation.
type OpenTunnelResponse struct {
	*OpenTunnelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// OpenTunnel request.
func (r *OpenTunnelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
