// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mediaconvertiface provides an interface to enable mocking the AWS Elemental MediaConvert service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mediaconvertiface

import (
	"github.com/aws/aws-sdk-go-v2/service/mediaconvert"
)

// ClientAPI provides an interface to enable mocking the
// mediaconvert.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // MediaConvert.
//    func myFunc(svc mediaconvertiface.ClientAPI) bool {
//        // Make svc.AssociateCertificate request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := mediaconvert.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        mediaconvertiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateCertificate(input *mediaconvert.AssociateCertificateInput) (*mediaconvert.AssociateCertificateOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateCertificateRequest(*mediaconvert.AssociateCertificateInput) mediaconvert.AssociateCertificateRequest

	CancelJobRequest(*mediaconvert.CancelJobInput) mediaconvert.CancelJobRequest

	CreateJobRequest(*mediaconvert.CreateJobInput) mediaconvert.CreateJobRequest

	CreateJobTemplateRequest(*mediaconvert.CreateJobTemplateInput) mediaconvert.CreateJobTemplateRequest

	CreatePresetRequest(*mediaconvert.CreatePresetInput) mediaconvert.CreatePresetRequest

	CreateQueueRequest(*mediaconvert.CreateQueueInput) mediaconvert.CreateQueueRequest

	DeleteJobTemplateRequest(*mediaconvert.DeleteJobTemplateInput) mediaconvert.DeleteJobTemplateRequest

	DeletePresetRequest(*mediaconvert.DeletePresetInput) mediaconvert.DeletePresetRequest

	DeleteQueueRequest(*mediaconvert.DeleteQueueInput) mediaconvert.DeleteQueueRequest

	DescribeEndpointsRequest(*mediaconvert.DescribeEndpointsInput) mediaconvert.DescribeEndpointsRequest

	DisassociateCertificateRequest(*mediaconvert.DisassociateCertificateInput) mediaconvert.DisassociateCertificateRequest

	GetJobRequest(*mediaconvert.GetJobInput) mediaconvert.GetJobRequest

	GetJobTemplateRequest(*mediaconvert.GetJobTemplateInput) mediaconvert.GetJobTemplateRequest

	GetPresetRequest(*mediaconvert.GetPresetInput) mediaconvert.GetPresetRequest

	GetQueueRequest(*mediaconvert.GetQueueInput) mediaconvert.GetQueueRequest

	ListJobTemplatesRequest(*mediaconvert.ListJobTemplatesInput) mediaconvert.ListJobTemplatesRequest

	ListJobsRequest(*mediaconvert.ListJobsInput) mediaconvert.ListJobsRequest

	ListPresetsRequest(*mediaconvert.ListPresetsInput) mediaconvert.ListPresetsRequest

	ListQueuesRequest(*mediaconvert.ListQueuesInput) mediaconvert.ListQueuesRequest

	ListTagsForResourceRequest(*mediaconvert.ListTagsForResourceInput) mediaconvert.ListTagsForResourceRequest

	TagResourceRequest(*mediaconvert.TagResourceInput) mediaconvert.TagResourceRequest

	UntagResourceRequest(*mediaconvert.UntagResourceInput) mediaconvert.UntagResourceRequest

	UpdateJobTemplateRequest(*mediaconvert.UpdateJobTemplateInput) mediaconvert.UpdateJobTemplateRequest

	UpdatePresetRequest(*mediaconvert.UpdatePresetInput) mediaconvert.UpdatePresetRequest

	UpdateQueueRequest(*mediaconvert.UpdateQueueInput) mediaconvert.UpdateQueueRequest
}

var _ ClientAPI = (*mediaconvert.Client)(nil)
