// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMultiplexInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMultiplexInput"}

	if s.MultiplexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MultiplexId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeMultiplexInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MultiplexId != nil {
		v := *s.MultiplexId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "multiplexId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []string `locationName:"availabilityZones" type:"list"`

	Destinations []MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State MultiplexState `locationName:"state" type:"string" enum:"true"`

	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeMultiplexOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AvailabilityZones != nil {
		v := s.AvailabilityZones

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "availabilityZones", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Destinations != nil {
		v := s.Destinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "destinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MultiplexSettings != nil {
		v := s.MultiplexSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "multiplexSettings", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PipelinesRunningCount != nil {
		v := *s.PipelinesRunningCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelinesRunningCount", protocol.Int64Value(v), metadata)
	}
	if s.ProgramCount != nil {
		v := *s.ProgramCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programCount", protocol.Int64Value(v), metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opDescribeMultiplex = "DescribeMultiplex"

// DescribeMultiplexRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Gets details about a multiplex.
//
//    // Example sending a request using DescribeMultiplexRequest.
//    req := client.DescribeMultiplexRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex
func (c *Client) DescribeMultiplexRequest(input *DescribeMultiplexInput) DescribeMultiplexRequest {
	op := &aws.Operation{
		Name:       opDescribeMultiplex,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &DescribeMultiplexInput{}
	}

	req := c.newRequest(op, input, &DescribeMultiplexOutput{})
	return DescribeMultiplexRequest{Request: req, Input: input, Copy: c.DescribeMultiplexRequest}
}

// DescribeMultiplexRequest is the request type for the
// DescribeMultiplex API operation.
type DescribeMultiplexRequest struct {
	*aws.Request
	Input *DescribeMultiplexInput
	Copy  func(*DescribeMultiplexInput) DescribeMultiplexRequest
}

// Send marshals and sends the DescribeMultiplex API request.
func (r DescribeMultiplexRequest) Send(ctx context.Context) (*DescribeMultiplexResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMultiplexResponse{
		DescribeMultiplexOutput: r.Request.Data.(*DescribeMultiplexOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMultiplexResponse is the response type for the
// DescribeMultiplex API operation.
type DescribeMultiplexResponse struct {
	*DescribeMultiplexOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMultiplex request.
func (r *DescribeMultiplexResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
