// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackage

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateHarvestJobInput struct {
	_ struct{} `type:"structure"`

	// EndTime is a required field
	EndTime *string `locationName:"endTime" type:"string" required:"true"`

	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// OriginEndpointId is a required field
	OriginEndpointId *string `locationName:"originEndpointId" type:"string" required:"true"`

	// Configuration parameters for where in an S3 bucket to place the harvested
	// content
	//
	// S3Destination is a required field
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure" required:"true"`

	// StartTime is a required field
	StartTime *string `locationName:"startTime" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHarvestJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHarvestJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateHarvestJobInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.OriginEndpointId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OriginEndpointId"))
	}

	if s.S3Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Destination"))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateHarvestJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginEndpointId != nil {
		v := *s.OriginEndpointId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "originEndpointId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Destination != nil {
		v := s.S3Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Destination", v, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateHarvestJobOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	ChannelId *string `locationName:"channelId" type:"string"`

	CreatedAt *string `locationName:"createdAt" type:"string"`

	EndTime *string `locationName:"endTime" type:"string"`

	Id *string `locationName:"id" type:"string"`

	OriginEndpointId *string `locationName:"originEndpointId" type:"string"`

	// Configuration parameters for where in an S3 bucket to place the harvested
	// content
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`

	StartTime *string `locationName:"startTime" type:"string"`

	Status Status `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateHarvestJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateHarvestJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginEndpointId != nil {
		v := *s.OriginEndpointId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "originEndpointId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Destination != nil {
		v := s.S3Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Destination", v, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opCreateHarvestJob = "CreateHarvestJob"

// CreateHarvestJobRequest returns a request value for making API operation for
// AWS Elemental MediaPackage.
//
// Creates a new HarvestJob record.
//
//    // Example sending a request using CreateHarvestJobRequest.
//    req := client.CreateHarvestJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/CreateHarvestJob
func (c *Client) CreateHarvestJobRequest(input *CreateHarvestJobInput) CreateHarvestJobRequest {
	op := &aws.Operation{
		Name:       opCreateHarvestJob,
		HTTPMethod: "POST",
		HTTPPath:   "/harvest_jobs",
	}

	if input == nil {
		input = &CreateHarvestJobInput{}
	}

	req := c.newRequest(op, input, &CreateHarvestJobOutput{})
	return CreateHarvestJobRequest{Request: req, Input: input, Copy: c.CreateHarvestJobRequest}
}

// CreateHarvestJobRequest is the request type for the
// CreateHarvestJob API operation.
type CreateHarvestJobRequest struct {
	*aws.Request
	Input *CreateHarvestJobInput
	Copy  func(*CreateHarvestJobInput) CreateHarvestJobRequest
}

// Send marshals and sends the CreateHarvestJob API request.
func (r CreateHarvestJobRequest) Send(ctx context.Context) (*CreateHarvestJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateHarvestJobResponse{
		CreateHarvestJobOutput: r.Request.Data.(*CreateHarvestJobOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateHarvestJobResponse is the response type for the
// CreateHarvestJob API operation.
type CreateHarvestJobResponse struct {
	*CreateHarvestJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateHarvestJob request.
func (r *CreateHarvestJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
